/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SmokeColumnMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemDustOfVanishing
extends ItemGeneric {
    public ItemDustOfVanishing() {
        super("dust_of_vanishing", () -> ConfigTombstone.allowedMagicItems.allowDustOfVanishing());
        this.withEffect();
    }

    public String func_77653_i(ItemStack stack) {
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            this.addItemUse(list);
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == this) {
            if (EntityHelper.hasGlobalItemCooldown(player, this)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            Vec3d pVec = player.func_174791_d();
            if (!world.field_72995_K) {
                world.func_184148_a(null, pVec.field_72450_a, pVec.field_72448_b, pVec.field_72449_c, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 0.5f);
                Location spawnPos = this.findBackwardLocation((WorldServer)world, player, 8.0);
                if (!spawnPos.isOrigin()) {
                    Helper.teleport(player, spawnPos);
                } else {
                    spawnPos = this.findBackwardLocation((WorldServer)world, player, 3.0);
                    if (!spawnPos.isOrigin()) {
                        Helper.teleport(player, spawnPos);
                    }
                }
                player.field_70143_R = 0.0f;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                EffectHelper.addPotion((EntityLivingBase)player, ModEffects.diversion, 100);
                EntityHelper.setGlobalItemCooldown(player, this, 200);
                PacketHandler.INSTANCE.sendToAllTracking((IMessage)new SmokeColumnMessage(player.func_145782_y()), (Entity)player);
                ModTriggers.USE_VANISHING.trigger((EntityPlayerMP)player);
            }
            ModTombstone.PROXY.produceSmokeColumn(world, pVec.field_72450_a, pVec.field_72448_b, pVec.field_72449_c);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        return false;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (EntityHelper.isValidPlayer(player)) {
            return this.func_77659_a(world, player, hand).func_188397_a();
        }
        return EnumActionResult.FAIL;
    }

    private Location findBackwardLocation(WorldServer world, EntityPlayer player, double range) {
        return new SpawnHelper(world, new BlockPos(player.func_174791_d().func_178786_a(player.func_70040_Z().field_72450_a * range, 0.0, player.func_70040_Z().field_72449_c * range)), false).findSafePlace(2, true, true);
    }
}

