/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFamiliarReceptacle
extends ItemGeneric
implements IDelayedNBTLoot {
    private static final String CAPTURABLE_TYPE_NBT_STRING = "capturable_type";
    private static final String DEAD_PET_NBT_COMPOUND = "dead_pet";

    public ItemFamiliarReceptacle() {
        super("familiar_receptacle", () -> ConfigTombstone.allowedMagicItems.allowFamiliarReceptacle());
        this.func_77625_d(1);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.isEnabled()) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            NBTTagCompound pet_tag = new NBTTagCompound();
            pet_tag.func_74778_a("id", TameableType.getRandomTameableEntityTypeString());
            NBTStackHelper.getOrCreateTag(stack).func_74782_a(DEAD_PET_NBT_COMPOUND, (NBTBase)pet_tag);
            items.add((Object)stack);
        }
    }

    public String func_77653_i(ItemStack stack) {
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + super.func_77653_i(stack);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        String id;
        if (EntityHelper.isValidServerPlayer((Entity)player) && !(id = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING)).isEmpty()) {
            ModTriggers.IMPREGNATED_RECEPTACLE.trigger((EntityPlayerMP)player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.containSoul(stack) || super.func_77636_d(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            NBTTagCompound pet_tag = this.getDeadPetTag(stack).orElse(null);
            if (pet_tag == null) {
                this.addItemDesc(list, "1", new Object[0]);
                String id = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING);
                if (!id.isEmpty()) {
                    list.add(LangKey.MESSAGE_IMPREGNATE.getClientTranslationWithStyle(StyleType.MESSAGE_SPECIAL, LangKey.getEntityName(id)));
                }
            } else if (pet_tag.func_150297_b("id", 8)) {
                this.addItemDesc(list, "2", LangKey.getEntityName(pet_tag.func_74779_i("id")));
                this.addItemUse(list, this.getDurabilityForDisplay(stack) == 0.0 ? "2" : "1", new Object[0]);
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && TimeHelper.atInterval(entity, TimeHelper.tickFromMinute(1))) {
            this.getDeadPetTag(stack).ifPresent(pet_tag -> {
                float maxHealth;
                float health = pet_tag.func_150297_b("Health", 5) ? Math.max(0.0f, pet_tag.func_74760_g("Health")) : 1.0f;
                float f = maxHealth = pet_tag.func_150297_b("max_life", 5) ? Math.max(1.0f, pet_tag.func_74760_g("max_life")) : 1.0f;
                if (health < maxHealth) {
                    float gain = maxHealth * 0.1f;
                    EntityPlayer player = (EntityPlayer)entity;
                    pet_tag.func_74776_a("Health", Math.min(health + Math.min(player.func_110143_aJ(), gain), maxHealth));
                    if (ConfigTombstone.general.allowBeyondTheGraveDamage) {
                        player.func_70097_a(ModDamages.BEYOND_THE_GRAVE, gain);
                    }
                }
            });
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.containSoul(stack) && this.getDurabilityForDisplay(stack) > 0.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getDeadPetTag(stack).map(pet_tag -> {
            float health = pet_tag.func_150297_b("Health", 5) ? Math.max(0.0f, pet_tag.func_74760_g("Health")) : 1.0f;
            float maxHealth = pet_tag.func_150297_b("max_life", 5) ? Math.max(1.0f, pet_tag.func_74760_g("max_life")) : 1.0f;
            return Float.valueOf(1.0f - health / maxHealth);
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean containSoul(ItemStack stack) {
        return stack.func_77973_b() == this && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(DEAD_PET_NBT_COMPOUND, 10);
    }

    private Optional<NBTTagCompound> getDeadPetTag(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p()).filter(tag -> tag.func_150297_b(DEAD_PET_NBT_COMPOUND, 10)).map(tag -> tag.func_74775_l(DEAD_PET_NBT_COMPOUND));
    }

    public boolean revive(EntityPlayer player, BlockPos gravePos, ItemStack stack) {
        Entity entity;
        NBTTagCompound pet_tag = this.getDeadPetTag(stack).orElse(null);
        if (pet_tag != null && pet_tag.func_150297_b("id", 8) && (entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(pet_tag.func_74779_i("id")), (World)player.field_70170_p)) instanceof EntityLivingBase) {
            EntityLivingBase tamedEntity = (EntityLivingBase)entity;
            if (pet_tag.func_74764_b("max_life")) {
                pet_tag.func_82580_o("max_life");
                tamedEntity.func_70020_e(pet_tag);
                tamedEntity.func_70107_b((double)gravePos.func_177958_n() + 0.5, (double)gravePos.func_177956_o() + 0.5, (double)gravePos.func_177952_p() + 0.5);
            } else if (tamedEntity instanceof EntityLiving) {
                tamedEntity.func_70107_b((double)gravePos.func_177958_n() + 0.5, (double)gravePos.func_177956_o() + 0.5, (double)gravePos.func_177952_p() + 0.5);
                ((EntityLiving)tamedEntity).func_180482_a(player.field_70170_p.func_175649_E(tamedEntity.func_180425_c()), null);
            }
            tamedEntity.func_70606_j(tamedEntity.func_110138_aP());
            tamedEntity.field_70128_L = false;
            tamedEntity.field_71093_bK = player.field_71093_bK;
            TameableType.setTamedBy(player, entity);
            EffectHelper.clearBadEffects(tamedEntity);
            player.field_70170_p.func_72838_d((Entity)tamedEntity);
            return true;
        }
        return false;
    }

    public ItemStack setCapturableType(ItemStack stack, String type) {
        NBTStackHelper.setString(stack, CAPTURABLE_TYPE_NBT_STRING, type);
        return stack;
    }

    private boolean canCaptureSoul(ItemStack stack, EntityLivingBase entity) {
        String type = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING);
        return type.isEmpty() || type.equals(EntityHelper.getRegistryString((Entity)entity));
    }

    public boolean captureSoul(EntityLivingBase entity) {
        boolean hasReceptacle;
        boolean wasOffline;
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        String entityString = EntityHelper.getRegistryString((Entity)entity);
        if (entityString.isEmpty()) {
            return false;
        }
        TameableType tameableType = TameableType.getType(entityString);
        if (tameableType == null) {
            return false;
        }
        UUID ownerId = tameableType.getOwnerId((Entity)entity);
        MinecraftServer server = entity.func_184102_h();
        if (ownerId == null || server == null) {
            return false;
        }
        EntityPlayerMP owner = server.func_184103_al().func_177451_a(ownerId);
        boolean bl = wasOffline = owner == null;
        if (wasOffline && (owner = EntityHelper.getOfflinePlayer(server, ownerId)) == null) {
            return false;
        }
        ItemStack receptacle = owner.func_70089_S() ? InventoryHelper.findFirstInInventory((EntityPlayer)owner, stack -> stack.func_77973_b() == this && this.canCaptureSoul((ItemStack)stack, entity) && !this.containSoul((ItemStack)stack)) : ItemStack.field_190927_a;
        boolean bl2 = hasReceptacle = !receptacle.func_190926_b();
        if (hasReceptacle && EventFactory.onCaptureSoul((EntityPlayer)owner, entity)) {
            hasReceptacle = false;
        }
        if (!hasReceptacle && !ConfigTombstone.recovery.recoveryFamiliarEnable) {
            return false;
        }
        if (hasReceptacle) {
            if (entity.func_184218_aH()) {
                entity.func_184210_p();
            }
            if (entity.func_184207_aI()) {
                entity.func_184226_ay();
            }
        }
        NBTTagCompound pet_tag = entity.serializeNBT();
        pet_tag.func_82580_o("Dimension");
        pet_tag.func_82580_o("Motion");
        pet_tag.func_82580_o("UUID");
        pet_tag.func_82580_o("UpdateBlocked");
        pet_tag.func_74776_a("Health", 0.0f);
        pet_tag.func_74776_a("max_life", entity.func_110138_aP());
        if (!hasReceptacle) {
            CommandTBReviveFamiliar.saveFamiliar(server, ownerId, pet_tag, entity.func_110124_au().toString());
            return false;
        }
        IItemHandler inventory = InventoryHelper.getItemHandler((Entity)entity);
        IntStream.range(0, inventory.getSlots()).forEach(slot -> {
            ItemStack currentStack = inventory.getStackInSlot(slot);
            if (!currentStack.func_190926_b()) {
                inventory.extractItem(slot, currentStack.func_190916_E(), false);
            }
        });
        tameableType.onCapture((Entity)entity, pet_tag);
        NBTStackHelper.getOrCreateTag(receptacle).func_74782_a(DEAD_PET_NBT_COMPOUND, (NBTBase)pet_tag);
        if (wasOffline) {
            EntityHelper.writePlayerData(server, owner);
        } else {
            LangKey.MESSAGE_CAPTURE_FAMILIAR.sendSpecialMessage((ICommandSender)owner, entity.func_70005_c_());
            ModTriggers.CAPTURE_SOUL.trigger(owner);
        }
        return true;
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(DEAD_PET_NBT_COMPOUND, 10)) {
            NBTTagCompound tag = stack.func_77978_p().func_74737_b();
            NBTTagCompound pet_tag = (NBTTagCompound)tag.func_74781_a(DEAD_PET_NBT_COMPOUND);
            if (pet_tag.func_150297_b("id", 8)) {
                NBTTagCompound newTag = new NBTTagCompound();
                newTag.func_74778_a("id", pet_tag.func_74779_i("id"));
                if (pet_tag.func_74764_b("Health")) {
                    newTag.func_74776_a("Health", pet_tag.func_74760_g("Health"));
                }
                if (pet_tag.func_74764_b("max_life")) {
                    newTag.func_74776_a("max_life", pet_tag.func_74760_g("max_life"));
                }
                tag.func_74782_a(DEAD_PET_NBT_COMPOUND, (NBTBase)newTag);
            } else {
                pet_tag.func_82580_o(DEAD_PET_NBT_COMPOUND);
            }
            return tag;
        }
        return stack.func_77978_p();
    }

    public ItemStack createWithRandomFamiliar() {
        return this.setRandomFamiliar(new ItemStack((Item)this));
    }

    private ItemStack setRandomFamiliar(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            NBTTagCompound pet_tag = new NBTTagCompound();
            pet_tag.func_74778_a("id", TameableType.getRandomTameableEntityTypeString());
            NBTStackHelper.getOrCreateTag(stack).func_74782_a(DEAD_PET_NBT_COMPOUND, (NBTBase)pet_tag);
        }
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, NBTTagCompound tag, LootContext context) {
        return this.setRandomFamiliar(stack);
    }
}

