/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFishingRodOfMisadventure
extends ItemFishingRod
implements ISoulConsumer,
IDelayedNBTLoot {
    private final String name = "fishing_rod_of_misadventure";

    public ItemFishingRodOfMisadventure() {
        this.setRegistryName("fishing_rod_of_misadventure");
        this.func_77655_b("fishing_rod_of_misadventure");
        this.func_77656_e(32);
        this.func_77625_d(1);
        this.func_77637_a(ModTabs.tabTombstone);
        this.func_185043_a(new ResourceLocation("cast"), (stack, world, entity) -> (ModItems.fishing_rod_of_misadventure.isAncient(stack) ? 0.01f : 0.0f) + (entity instanceof EntityPlayer && (entity.func_184614_ca() == stack || entity.func_184592_cb() == stack) && ((EntityPlayer)entity).field_71104_cf != null ? 0.1f : 0.0f));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack enchantedStack = NBTStackHelper.setBoolean(new ItemStack((Item)this), "enchant", true);
            items.add((Object)enchantedStack);
            items.add((Object)NBTStackHelper.setBoolean(enchantedStack.func_77946_l(), "ancient", true));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getServerTranslation(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getServerTranslation(name) : name));
    }

    public boolean isAncient(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "ancient");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            int speed;
            boolean isEnchanted = this.isEnchanted(stack);
            boolean isAncient = this.isAncient(stack);
            tooltip.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_DESC, "tombstone.item.fishing_rod_of_misadventure.desc" + (isEnchanted ? 2 : 1), new Object[0]));
            tooltip.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_USE, "tombstone.item.fishing_rod_of_misadventure.use" + (isEnchanted ? 2 : 1), new Object[0]));
            tooltip.add(TextFormatting.GRAY + LangKey.makeClientTranslation("enchantment.tombstone.fishing_bad_luck.name", new Object[0]) + " " + (isAncient ? "X" : (isEnchanted ? "V" : "I")));
            int n = isAncient ? 5 : (speed = isEnchanted ? 2 : 0);
            if (speed > 0) {
                tooltip.add(Enchantments.field_151369_A.func_77316_c(speed));
            }
            if (isAncient) {
                tooltip.add(ModEnchantments.soulbound.func_77316_c(1));
            }
        } else {
            tooltip.add(LangKey.TOOLTIP_MORE_INFO.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, new Object[0]));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean isEnchanted = this.isEnchanted(stack);
        if (player.field_71104_cf != null) {
            stack.func_77972_a(player.field_71104_cf.func_146034_e(), (EntityLivingBase)player);
            player.func_184609_a(hand);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        } else {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                boolean isAncient = this.isAncient(stack);
                EntityFishHook entityfishhook = new EntityFishHook(world, player);
                if (this.isEnchanted(stack)) {
                    entityfishhook.func_191516_a(2);
                }
                entityfishhook.func_191517_b(-(isAncient ? 100 : (isEnchanted ? 50 : 10)));
                entityfishhook.func_191516_a(isAncient ? 5 : (isEnchanted ? 2 : 0));
                world.func_72838_d((Entity)entityfishhook);
            }
            player.func_184609_a(hand);
            StatBase statList = StatList.func_188057_b((Item)this);
            if (statList != null) {
                player.func_71029_a(statList);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isEnchanted(stack) && super.showDurabilityBar(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (!this.isEnchanted(stack)) {
            super.setDamage(stack, damage);
        }
    }

    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        if (stack.func_77973_b() == this) {
            stack.func_77964_b(0);
            NBTStackHelper.setBoolean(stack, "enchant", true);
            if (!this.isAncient(stack) && hasStrongSoul) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_FISHING_ROD.trigger(player);
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_FAILED.getTranslation(new Object[0]);
    }

    public String func_77658_a() {
        return "tombstone.item.fishing_rod_of_misadventure";
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TBSoulConsumerProvider(this);
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, NBTTagCompound tag, LootContext context) {
        return NBTStackHelper.setBoolean(NBTStackHelper.setBoolean(stack, "enchant", true), "ancient", true);
    }
}

