/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.recipe.IDisableable;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModTabs;

public class ItemGeneric
extends Item
implements IDisableable {
    protected final String name;
    private boolean hasEffect;
    private boolean isCraftingIngredient;
    private final BooleanSupplier supplierEnabled;
    protected static final String ENCHANT_NBT_BOOL = "enchant";

    public ItemGeneric(String name, boolean hasTab, boolean hasEffect, boolean isCraftingIngredient) {
        this(name, hasTab, hasEffect, isCraftingIngredient, () -> true);
    }

    public ItemGeneric(String name, BooleanSupplier supplierEnabled) {
        this(name, true, false, false, supplierEnabled);
    }

    public ItemGeneric(String name, boolean hasTab, boolean hasEffect, boolean isCraftingIngredient, BooleanSupplier supplierEnabled) {
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.name = name;
        this.func_77637_a((CreativeTabs)(hasTab ? ModTabs.tabTombstone : null));
        this.func_77625_d(64);
        this.hasEffect = hasEffect;
        this.isCraftingIngredient = isCraftingIngredient;
        this.supplierEnabled = supplierEnabled;
    }

    public String getSimpleName() {
        return this.name;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.isEnabled()) {
            items.add((Object)new ItemStack((Item)this));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.supplierEnabled.getAsBoolean();
    }

    public ItemGeneric withEffect() {
        this.hasEffect = true;
        return this;
    }

    public ItemGeneric withCraftingInfo() {
        this.isCraftingIngredient = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.hasEffect || NBTStackHelper.getBoolean(stack, ENCHANT_NBT_BOOL);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (this.isCraftingIngredient) {
            list.add(LangKey.MESSAGE_CRAFTING_INGREDIENT.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, new Object[0]));
        }
        if (!this.isEnabled()) {
            this.addWarn(list, LangKey.MESSAGE_DISABLED, new Object[0]);
        }
    }

    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void addItemDesc(List<String> list) {
        this.addItemDesc(list, "", new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void addItemDesc(List<String> list, String id, Object ... format) {
        list.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_DESC, "tombstone.item." + this.name + ".desc" + id, format));
    }

    @SideOnly(value=Side.CLIENT)
    public void addItemUse(List<String> list) {
        this.addItemUse(list, "", new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void addItemUse(List<String> list, String id, Object ... format) {
        list.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_USE, "tombstone.item." + this.name + ".use" + id, format));
    }

    @SideOnly(value=Side.CLIENT)
    public void addItemUse(List<String> list, LangKey langKey, Object ... format) {
        list.add(langKey.getClientTranslationWithStyle(StyleType.TOOLTIP_USE, format));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInfo(List<String> list, LangKey langKey, Object ... format) {
        list.add(langKey.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, format));
    }

    @SideOnly(value=Side.CLIENT)
    public void addWarn(List<String> list, LangKey langKey, Object ... format) {
        list.add(langKey.getClientTranslationWithStyle(StyleType.COLOR_OFF, format));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInfoInBeta(List<String> list) {
        list.add(LangKey.TOOLTIP_IN_BETA.getClientTranslationWithStyle(StyleType.TOOLTIP_IN_BETA, new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInfoShowTooltip(List<String> list) {
        this.addInfo(list, LangKey.TOOLTIP_MORE_INFO, new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void addRawText(List<String> list, String text) {
        list.add(StyleType.TOOLTIP_IN_BETA.func_150218_j() + text);
    }

    @SideOnly(value=Side.CLIENT)
    public void addItemPosition(List<String> list, Location location) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && !location.isOrigin()) {
            BlockPos pos = player.func_180425_c();
            list.add(LangKey.MESSAGE_DISTANCE.getClientTranslation((int)location.getPos().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), location.x, location.y, location.z, location.dim));
        }
    }
}

