/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class ItemGraveKey
extends ItemGraveMagic {
    public ItemGraveKey() {
        super("grave_key", () -> ConfigTombstone.allowedMagicItems.allowGraveKey());
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            String id = this.isEnchanted(stack) ? "2" : "1";
            this.addItemDesc(list, id, new Object[0]);
            Location location = this.getTombPos(stack);
            if (!location.isOrigin()) {
                this.addItemPosition(list, location);
            }
            this.addItemUse(list, id, new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public boolean setTombPos(ItemStack stack, Location location) {
        if (stack.func_77973_b() == this && !location.isOrigin()) {
            NBTStackHelper.setLocation(stack, "tombPos", location);
            return true;
        }
        return false;
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, "tombPos");
        }
        return Location.ORIGIN;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && EntityHelper.isValidPlayer(entity) && stack.func_77973_b() == this) {
            Location location = this.getTombPos(stack);
            boolean isBadKey = location.isOrigin();
            if (!isBadKey && TimeHelper.atInterval(entity, TimeHelper.tickFromSecond(isSelected && entity.func_70092_e((double)location.getPos().func_177958_n(), (double)location.getPos().func_177956_o(), (double)location.getPos().func_177952_p()) < 100.0 ? 10 : 120))) {
                if (!location.isSameDimension(world)) {
                    return;
                }
                if (!world.func_189509_E(location.getPos())) {
                    if (!world.func_175667_e(location.getPos())) {
                        world.func_180495_p(location.getPos());
                    }
                    isBadKey = !(world.func_175625_s(location.getPos()) instanceof TileEntityPlayerGrave);
                } else {
                    isBadKey = true;
                }
            }
            if (isBadKey) {
                stack.func_190918_g(1);
                ((EntityPlayer)entity).field_71069_bz.func_75142_b();
            }
        }
    }

    public boolean removeKeyForGraveInInventory(EntityPlayer player, Location graveLoc) {
        return InventoryHelper.removeFirstInInventory(player, stack -> stack.func_77973_b() == this && ModItems.grave_key.getTombPos((ItemStack)stack).equals(graveLoc));
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_CANT_ENCHANT_GRAVE_KEY.getTranslation(new Object[0]);
    }

    @Override
    protected boolean doEffects(WorldServer world, EntityPlayerMP player, ItemStack stack) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        if (!location.isSameDimension((World)world) && !ConfigTombstone.general.teleportDim) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        assert (player.func_184102_h() != null);
        WorldServer targetWorld = player.func_184102_h().func_71218_a(location.dim);
        if (!Helper.isValidDimension(location.dim) || !Helper.isValidPos((World)targetWorld, location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", false);
        CallbackHandler.addFastCallback(() -> {
            EntityPlayer newPlayer = (EntityPlayer)Helper.teleportToGrave(player, location);
            if (ConfigTombstone.player_death.nerfGhostlyShapeTeleportWithKey) {
                EffectHelper.capDuration((EntityLivingBase)newPlayer, ModEffects.ghostly_shape, 200);
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newPlayer, new Object[0]);
            ModTriggers.TELEPORT_TO_GRAVE.trigger(player);
        });
        return true;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    public void reenchantOnDeath(EntityPlayer player, ItemStack key) {
        int chanceEnchantedKey;
        if (key.func_77973_b() == this && (chanceEnchantedKey = ConfigTombstone.general.getChanceEnchantedGraveKey()) >= 0 && ((chanceEnchantedKey += EntityHelper.getPerkLevelWithBonus(player, ModPerks.jailer) * 20) >= 100 || chanceEnchantedKey > 0 && Helper.getRandom(1, 100) <= chanceEnchantedKey)) {
            NBTStackHelper.setBoolean(key, "enchant", true);
        }
    }

    @Override
    protected boolean canBlockInteractFirst(IBlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || ModBlocks.isPlayerGrave(state.func_177230_c());
    }
}

