/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SoundHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.IChanneling;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModBlocks;

public abstract class ItemGraveMagic
extends ItemGeneric
implements ISoulConsumer,
IChanneling {
    private static final Map<UUID, Long> USING = new ConcurrentHashMap<UUID, Long>();
    protected static final String ANCIENT_NBT_BOOL = "ancient";
    protected static final String USE_COUNT_NBT_INT = "useCount";
    protected static final String COOLDOWN_TIME_NBT_LONG = "cooldown_time";

    ItemGraveMagic(String name, BooleanSupplier supplierBoolean) {
        super(name, supplierBoolean);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getServerTranslation(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getServerTranslation(name) : name));
    }

    public boolean isAncient(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, ANCIENT_NBT_BOOL);
    }

    protected abstract boolean doEffects(WorldServer var1, EntityPlayerMP var2, ItemStack var3);

    protected ItemStack onConsumeItem(EntityPlayer player, ItemStack stack) {
        int useCount = this.getUseCount(stack);
        if (useCount < 2) {
            return ItemStack.field_190927_a;
        }
        this.setUseCount(stack, --useCount);
        return stack;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (!Helper.canShowTooltip()) {
            this.addInfoShowTooltip(list);
        }
        if (this.isEnchanted(stack)) {
            int cd;
            int uses;
            if (this.canConsumeOnUse() && (uses = this.getUseCount(stack)) > 0) {
                this.addInfo(list, LangKey.MESSAGE_USE_LEFT, uses);
            }
            if ((cd = this.getCooldown(world, stack)) > 10) {
                this.addWarn(list, LangKey.MESSAGE_IN_COOLDOWN, TimeHelper.getTimeStringWithUnit(cd));
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isEnchanted(stack)) {
            int cd = this.getCooldown(world, stack);
            boolean hasGCD = EntityHelper.hasGlobalItemCooldown(player, this);
            if (cd > 0 || hasGCD) {
                if (!hasGCD && !world.field_72995_K) {
                    EntityHelper.setGlobalItemCooldown(player, this, 20);
                    LangKey.MESSAGE_IN_COOLDOWN.sendMessage((ICommandSender)player, TimeHelper.getTimeStringWithUnit(cd));
                }
            } else {
                player.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        return false;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (EntityHelper.isValidPlayer(player)) {
            if (this.canBlockInteractFirst(world.func_180495_p(pos), player.func_184586_b(hand))) {
                return EnumActionResult.PASS;
            }
            return this.func_77659_a(world, player, hand).func_188397_a();
        }
        return EnumActionResult.FAIL;
    }

    protected boolean canBlockInteractFirst(IBlockState state, ItemStack stack) {
        return !this.isEnchanted(stack) || ModBlocks.isDecorativeGrave(state.func_177230_c());
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int timeLeft) {
        if (this.isEnchanted(stack)) {
            this.onChanneling(stack, entity, timeLeft);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (EntityHelper.isValidServerPlayer((Entity)entity)) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (this.isEnchanted(stack)) {
                if (this.doEffects((WorldServer)world, player, stack)) {
                    SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c());
                    if (!player.field_71075_bZ.field_75098_d && this.canConsumeOnUse()) {
                        stack = this.onConsumeItem((EntityPlayer)player, stack);
                    }
                    if (!stack.func_190926_b()) {
                        this.setCooldown(world, stack, this.getCastingCooldown());
                    }
                } else {
                    EntityHelper.setGlobalItemCooldown((EntityPlayer)player, this, 10);
                }
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public abstract int getCastingCooldown();

    public int getCooldown(@Nullable World world, ItemStack stack) {
        return world != null && stack.func_77973_b() == this ? NBTStackHelper.getTimer(TimeHelper.worldTicks(world), stack, COOLDOWN_TIME_NBT_LONG, this.getCastingCooldown()) : 0;
    }

    public void setCooldown(@Nullable World world, ItemStack stack, int time) {
        if (world != null && stack.func_77973_b() == this) {
            NBTStackHelper.setLong(stack, COOLDOWN_TIME_NBT_LONG, TimeHelper.worldTicks(world) + (long)time);
        }
    }

    public abstract int getUseMax();

    public abstract boolean canConsumeOnUse();

    public int getUseCount(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return Math.min(NBTStackHelper.getInteger(stack, USE_COUNT_NBT_INT), this.getUseMax());
    }

    protected ItemStack setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, USE_COUNT_NBT_INT, Math.min(useCount, this.getUseMax()));
        }
        return stack;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_FAILED.getTranslation(new Object[0]);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

