/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.registry.RegistryHandler;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;

public class ItemGravePlate
extends ItemGeneric {
    public ItemGravePlate() {
        super("grave_plate", true, false, false);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_185043_a(new ResourceLocation("engraved"), (stack, worldIn, entityIn) -> EngravableHelper.isEngraved(stack) ? 1.0f : 0.0f);
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        displayName = super.func_77653_i(stack);
        return EngravableHelper.isEngraved(stack) ? LangKey.MESSAGE_ENGRAVED_ITEM.getClientTranslation(displayName) : displayName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            String engravedName = EngravableHelper.getEngravedName(stack);
            String displayName = super.func_77653_i(stack);
            if (!engravedName.isEmpty()) {
                displayName = LangKey.MESSAGE_ENGRAVED_ITEM.getClientTranslation(displayName);
            }
            if (tooltip.size() > 0) {
                tooltip.set(0, displayName);
            } else {
                tooltip.add(displayName);
            }
            if (engravedName.isEmpty()) {
                tooltip.add(LangKey.MESSAGE_ENGRAVABLE.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, StyleType.TOOLTIP_ITEM.func_150218_j() + "[" + LangKey.makeClientTranslation(Items.field_151042_j.func_77658_a() + ".name", new Object[0]).toLowerCase() + "]"));
            } else {
                tooltip.add(LangKey.MESSAGE_ENGRAVED.getClientTranslationWithStyle(StyleType.TOOLTIP_DESC, '\"' + engravedName + '\"'));
            }
        } else {
            this.addInfoShowTooltip(tooltip);
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (EntityHelper.isValidPlayer(player) && hand == EnumHand.MAIN_HAND) {
            IBlockState state = world.func_180495_p(pos);
            if (Arrays.stream(RegistryHandler.decorative_graves).anyMatch(b -> b == state.func_177230_c())) {
                ItemStack stack = player.func_184614_ca();
                EntityHelper.setGlobalItemCooldown(player, this, 100);
                String engravedName = EngravableHelper.getEngravedName(stack);
                if (!engravedName.isEmpty()) {
                    TileEntityDecorativeGrave tile;
                    if (!world.field_72995_K && (tile = ((BlockDecorativeGrave)state.func_177230_c()).getTileEntity((IBlockAccess)world, pos)) != null) {
                        String ownerName = tile.getOwnerName();
                        boolean wasEngraved = (Boolean)state.func_177229_b((IProperty)BlockGraveBase.IS_ENGRAVED);
                        IBlockState newState = state.func_177226_a((IProperty)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true));
                        if (!wasEngraved) {
                            world.func_180501_a(pos, newState, 3);
                        } else if (!ConfigTombstone.decorativeGrave.canReplaceGravePlate) {
                            LangKey.MESSAGE_GRAVE_PLATE_REPLACEMENT_NOT_ALLOWED.sendWarnMessage((ICommandSender)player, new Object[0]);
                            return EnumActionResult.FAIL;
                        }
                        tile.setOwner(engravedName, TimeHelper.systemTime());
                        tile.func_70296_d();
                        world.func_184138_a(pos, state, newState, 3);
                        if (ownerName.isEmpty()) {
                            stack.func_190918_g(1);
                        } else {
                            EngravableHelper.setEngravedName(stack, ownerName);
                        }
                        ModTriggers.ENGRAVE_DECORATIVE_GRAVE.trigger((EntityPlayerMP)player);
                    }
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.PASS;
    }

    public String func_77653_i(ItemStack stack) {
        return EngravableHelper.getEngravedName(stack);
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }
}

