/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ICustomModel;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLostTablet
extends ItemGraveMagic
implements ICustomModel {
    private static final String ROLL_NBT_SHORT = "roll";
    private static final String STRUCTURE_TYPE_NBT_INT = "structureType";
    private static final String PLACE_ID_NBT_STRING = "place_id";
    private static final String PLACE_NBT_LOCATION = "structurePos";

    public ItemLostTablet() {
        super("lost_tablet", () -> ConfigTombstone.allowedMagicItems.allowLostTablet());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            Location location = this.getLocation(stack);
            String id = location.isOrigin() ? "1" : (this.isEnchanted(stack) ? "3" : "2");
            this.addItemDesc(list, id, new Object[0]);
            if (!location.isOrigin()) {
                if (this.isExploration(stack)) {
                    String biomeId = NBTStackHelper.getString(stack, PLACE_ID_NBT_STRING);
                    if (!biomeId.isEmpty()) {
                        this.addRawText(list, Helper.getBiomeName(biomeId));
                    }
                } else {
                    SupportStructures struct = this.getStructureType(stack);
                    if (struct != null) {
                        this.addRawText(list, struct.name().replace("_", " "));
                    }
                }
                this.addItemPosition(list, location);
            }
            this.addItemUse(list, id, new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (stack.func_77973_b() == this && EntityHelper.isValidServerPlayer(entity) && stack.func_77960_j() == 0) {
            int cd;
            EntityPlayerMP player = (EntityPlayerMP)entity;
            int roll = NBTStackHelper.getShort(stack, ROLL_NBT_SHORT, (short)-1);
            if (roll == -1) {
                roll = Helper.RANDOM.nextInt(100) + EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.treasure_seeker) * 10;
                NBTStackHelper.setShort(stack, ROLL_NBT_SHORT, (short)roll);
            }
            if ((cd = this.getCooldown(world, stack)) <= 0) {
                this.setCooldown(world, stack, TimeHelper.tickFromSecond(500 + Helper.RANDOM.nextInt(301)));
            } else if (cd == 1) {
                if (this.wakeUpMagic(player, stack, roll)) {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
                } else if (Helper.RANDOM.nextBoolean()) {
                    this.setCooldown(world, stack, TimeHelper.tickFromSecond(1500 + Helper.RANDOM.nextInt(301)));
                } else {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
                    stack.func_190918_g(1);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)ItemCraftingIngredient.IngredientType.GRAVE_DUST.getStack(Helper.RANDOM.nextInt(4) + 2));
                    player.field_71069_bz.func_75142_b();
                    ModTriggers.GRAVE_DUST_FROM_BREAKING_TABLET.trigger(player);
                }
            }
        }
    }

    @Override
    public int getCooldown(@Nullable World world, ItemStack stack) {
        return world != null && stack.func_77973_b() == this ? NBTStackHelper.getTimer(TimeHelper.worldTicks(world), stack, "cooldown_time", 1800) : 0;
    }

    private DimensionType getWorldTypeForStructure(SupportStructures struct) {
        switch (struct) {
            case Fortress: {
                return DimensionType.NETHER;
            }
            case EndCity: {
                return DimensionType.THE_END;
            }
        }
        return DimensionType.OVERWORLD;
    }

    private boolean wakeUpMagic(EntityPlayerMP player, ItemStack stack, int roll) {
        Location location;
        boolean isBiomeExploration = false;
        SupportStructures struct = null;
        if (roll < 40) {
            isBiomeExploration = true;
        } else if (roll < 70) {
            struct = SupportStructures.Village;
        } else {
            struct = SupportStructures.getRandomStructure(p -> p != SupportStructures.Village);
            if (struct == null) {
                struct = SupportStructures.Village;
            }
        }
        WorldServer world = player.func_71121_q();
        if (isBiomeExploration) {
            location = new Location(Helper.getCloserValidPos((World)world, player.func_180425_c().func_177963_a(Helper.RANDOM.nextGaussian() * 10000.0 + 500.0, 0.0, Helper.RANDOM.nextGaussian() * 10000.0 + 500.0)), (World)world);
        } else {
            DimensionType worldType = this.getWorldTypeForStructure(struct);
            if (world.field_73011_w.func_186058_p() != worldType) {
                if (ConfigTombstone.decorativeGrave.allowTabletSearchOutsideWorld) {
                    int[] dimensionIds = DimensionManager.getDimensions((DimensionType)worldType);
                    if (dimensionIds.length == 0) {
                        return false;
                    }
                    assert (player.func_184102_h() != null);
                    world = player.func_184102_h().func_71218_a(dimensionIds[Helper.getRandom(0, dimensionIds.length - 1)]);
                    if (worldType == DimensionType.NETHER) {
                        ((ChunkGeneratorHell)world.func_72863_F().field_186029_c).field_73172_c.func_186125_a((World)world, Integer.MIN_VALUE, Integer.MIN_VALUE, null);
                    }
                } else {
                    return false;
                }
            }
            location = Helper.findNearestStructure(world, player.func_180425_c(), struct, true);
        }
        if (location.isOrigin() || !Helper.isValidPos((World)world, location.getPos())) {
            return false;
        }
        NBTStackHelper.setLocation(stack, PLACE_NBT_LOCATION, location);
        NBTStackHelper.removeKeyName(stack, ROLL_NBT_SHORT);
        if (isBiomeExploration) {
            stack.func_77964_b(3);
            NBTStackHelper.setString(stack, PLACE_ID_NBT_STRING, world.func_180494_b(location.getPos()).getRegistryName().toString());
            ModTriggers.FIND_EXPLORATION.trigger(player);
        } else if (struct == SupportStructures.Village) {
            stack.func_77964_b(1);
            NBTStackHelper.setInteger(stack, STRUCTURE_TYPE_NBT_INT, struct.ordinal());
            ModTriggers.FIND_VILLAGE.trigger(player);
        } else {
            stack.func_77964_b(2);
            NBTStackHelper.setInteger(stack, STRUCTURE_TYPE_NBT_INT, struct.ordinal());
            ModTriggers.FIND_TREASURE.trigger(player);
        }
        player.field_71069_bz.func_75142_b();
        return true;
    }

    @Nullable
    public SupportStructures getStructureType(ItemStack stack) {
        if (stack.func_77973_b() == this && NBTStackHelper.hasKeyName(stack, STRUCTURE_TYPE_NBT_INT)) {
            int ordinal = NBTStackHelper.getInteger(stack, STRUCTURE_TYPE_NBT_INT);
            return ordinal < SupportStructures.values().length ? SupportStructures.values()[ordinal] : null;
        }
        return null;
    }

    public boolean isWakeUp(ItemStack stack) {
        return stack.func_77973_b() == this && stack.func_77960_j() > 0;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return super.canEnchant(world, gravePos, player, stack) && this.isWakeUp(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isWakeUp(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        if (this.isWakeUp(stack)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(WorldServer world, EntityPlayerMP player, ItemStack stack) {
        String rl;
        Location location = this.getLocation(stack);
        if (location.isOrigin() || !Helper.isValidDimension(location.dim)) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        if (!ConfigTombstone.general.teleportDim && !location.isSameDimension((World)world)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        assert (player.func_184102_h() != null);
        WorldServer targetWorld = player.func_184102_h().func_71218_a(location.dim);
        if (!Helper.isValidPos((World)targetWorld, location.getPos())) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        Location spawnLoc = Helper.findSpawnForVillage(targetWorld, location.getPos());
        if (spawnLoc.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendWarnMessage((ICommandSender)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.setLocation(stack, PLACE_NBT_LOCATION, spawnLoc);
        if (this.isExploration(stack) && !(rl = world.func_180494_b(spawnLoc.getPos()).getRegistryName().toString()).equals(NBTStackHelper.getString(stack, PLACE_ID_NBT_STRING))) {
            NBTStackHelper.setString(stack, PLACE_ID_NBT_STRING, rl);
        }
        CallbackHandler.addCallback(1, () -> {
            EntityPlayer newPlayer = (EntityPlayer)Helper.teleport(player, spawnLoc);
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newPlayer, new Object[0]);
            ModTriggers.USE_LOST_TABLET.trigger(player);
        });
        return true;
    }

    private void resetStack(World world, ItemStack stack) {
        stack.func_77964_b(0);
        this.setCooldown(world, stack, TimeHelper.tickFromMinute(10));
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.removeLocation(stack, PLACE_NBT_LOCATION);
        NBTStackHelper.removeKeyName(stack, PLACE_ID_NBT_STRING);
    }

    public Location getLocation(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, PLACE_NBT_LOCATION);
        }
        return Location.ORIGIN;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public void registerModels() {
        assert (this.getRegistryName() != null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_village", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_treasure", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)3, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_exploration", "inventory"));
    }

    public boolean isExploration(ItemStack stack) {
        return stack.func_77960_j() == 3;
    }
}

