/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.NonNullList;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ICustomModel;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollBuff
extends ItemScroll
implements ICustomModel,
IDelayedNBTLoot {
    public ItemScrollBuff() {
        super("scroll_buff", () -> true);
        this.field_77787_bX = true;
    }

    @Override
    public boolean isEnabled(ItemStack stack) {
        return SpellBuff.getSpellBuf(stack).isEnable();
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (SpellBuff buff : SpellBuff.values()) {
                if (!buff.isEnable()) continue;
                items.add((Object)new ItemStack((Item)this, 1, buff.ordinal()));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            list.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_DESC, this.func_77667_c(stack) + ".desc", new Object[0]));
            this.addItemUse(list, this.isEnchanted(stack) ? LangKey.ITEM_SCROLL_BUFF_USE2 : LangKey.ITEM_SCROLL_BUFF_USE1, new Object[0]);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            list.add(StyleType.MESSAGE_SPELL.func_150218_j() + "(" + StringUtils.func_76337_a((int)MathHelper.func_76141_d((float)((float)ConfigTombstone.general.getScrollDuration() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.scribe) / 10.0f)))) + ")");
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        int meta = stack.func_77960_j();
        return stack.func_77973_b() == this && meta < SpellBuff.values().length && SpellBuff.values()[meta].isEnable();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(WorldServer world, EntityPlayerMP player, ItemStack stack) {
        SpellBuff buff = SpellBuff.values()[stack.func_77960_j()];
        Potion potion = (Potion)buff.potionSupplier.get();
        EffectHelper.addPotion((EntityLivingBase)player, potion, MathHelper.func_76128_c((double)((double)ConfigTombstone.general.getScrollDuration() * (1.0 + (double)EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.scribe) / 10.0))), buff.amplifier, new boolean[0]);
        LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMagicMessage((ICommandSender)player, LangKey.makeTranslationWithStyle(StyleType.MESSAGE_SPECIAL, potion.func_76393_a(), new Object[0]));
        ModTriggers.SPELL_BUFF.get((Object)buff).trigger(player);
        return true;
    }

    @Override
    public void registerModels() {
        for (SpellBuff buff : SpellBuff.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)buff.ordinal(), (ModelResourceLocation)new ModelResourceLocation("tombstone:" + buff.getScrollName(), "inventory"));
        }
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return "tombstone.item." + SpellBuff.values()[stack.func_77960_j()].getScrollName();
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, NBTTagCompound tag, LootContext context) {
        stack.func_77964_b(Helper.RANDOM.nextInt(SpellBuff.values().length));
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return stack;
    }

    public static enum SpellBuff {
        PRESERVATION(() -> ModEffects.preservation, 0, () -> ConfigTombstone.allowedMagicItems.allowScrollOfPreservation()),
        UNSTABLE_INTANGIBLENESS(() -> ModEffects.unstable_intangibleness, 0, () -> ConfigTombstone.allowedMagicItems.allowScrollOfUnstableIntangibleness()),
        FEATHER_FALL(() -> ModEffects.feather_fall, 3, () -> ConfigTombstone.allowedMagicItems.allowScrollOfFeatherFall()),
        PURIFICATION(() -> ModEffects.purification, 1, () -> ConfigTombstone.allowedMagicItems.allowScrollOfPurification()),
        TRUE_SIGHT(() -> ModEffects.true_sight, 0, () -> ConfigTombstone.allowedMagicItems.allowScrollOfTrueSight()),
        REACH(() -> ModEffects.reach, 5, () -> ConfigTombstone.allowedMagicItems.allowScrollOfReach()),
        LIGHTNING_RESISTANCE(() -> ModEffects.lightning_resistance, 0, () -> ConfigTombstone.allowedMagicItems.allowScrollOfLightningResistance()),
        FROST_RESISTANCE(() -> ModEffects.frost_resistance, 0, () -> ConfigTombstone.allowedMagicItems.allowScrollOfFrostResistance()),
        AQUATIC_LIFE(() -> ModEffects.aquatic_life, 0, () -> ConfigTombstone.allowedMagicItems.allowScrollOfAquaticLife());

        private final Supplier<Potion> potionSupplier;
        private final int amplifier;
        private final Supplier<Boolean> supplierEnabled;

        private SpellBuff(Supplier<Potion> potionSupplier, int amplifier, Supplier<Boolean> supplierEnabled) {
            this.potionSupplier = potionSupplier;
            this.amplifier = amplifier;
            this.supplierEnabled = supplierEnabled;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }

        private String getScrollName() {
            return "scroll_of_" + this.getName();
        }

        public boolean isEnable() {
            return this.supplierEnabled.get();
        }

        public static SpellBuff getSpellBuf(ItemStack stack) {
            return SpellBuff.values()[MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(SpellBuff.values().length - 1))];
        }

        public static Optional<ItemStack> getRandomEnchantedScroll() {
            return Helper.getRandomInList(Arrays.stream(SpellBuff.values()).filter(SpellBuff::isEnable).collect(Collectors.toList())).map(buff -> NBTStackHelper.setBoolean(new ItemStack((Item)ModItems.scroll_buff, 1, buff.ordinal()), "enchant", true));
        }
    }
}

