/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollOfKnowledge
extends ItemScroll
implements IDelayedNBTLoot {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge", () -> ConfigTombstone.allowedMagicItems.allowScrollOfKnowledge());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            if (!this.isEnchanted(stack)) {
                this.addItemDesc(list, "1", ConfigTombstone.general.getScrollOfKnowledgeLoss());
                this.addItemUse(list, "1", new Object[0]);
            } else {
                this.addItemDesc(list, "2", new Object[0]);
                this.addInfo(list, LangKey.MESSAGE_STORED_EXPERIENCE, this.getStoredXp(stack));
                this.addItemUse(list, "2", new Object[0]);
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_LOSE_EXPERIENCE_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_LOSE_EXPERIENCE_FAILED.getTranslation(new Object[0]);
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        float knowledgeLoss = (float)(100 - ConfigTombstone.general.getScrollOfKnowledgeLoss()) / 100.0f;
        boolean valid = this.setStoredXp(stack, (int)((float)EntityHelper.getPlayerTotalXp((EntityPlayer)player) * knowledgeLoss));
        if (valid) {
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
            player.field_71106_cc = 0.0f;
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(WorldServer world, EntityPlayerMP player, ItemStack stack) {
        int i;
        int storedXp = this.getStoredXp(stack);
        if (storedXp > (i = Integer.MAX_VALUE - player.field_71067_cb)) {
            LangKey.MESSAGE_EARN_EXPERIENCE_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        EntityHelper.setPlayerXp((EntityPlayer)player, EntityHelper.getPlayerTotalXp((EntityPlayer)player) + storedXp);
        LangKey.MESSAGE_EARN_EXPERIENCE_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
        ModTriggers.USE_KNOWLEDGE.trigger(player);
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        int storedXp = NBTStackHelper.getInteger(stack, "stored_xp");
        return storedXp > 0 ? storedXp : 0;
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (stack.func_77973_b() == this && xp > 0) {
            NBTStackHelper.setInteger(stack, "stored_xp", xp);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, NBTTagCompound tag, LootContext context) {
        tag.func_74768_a("stored_xp", Helper.getRandom(100, 2000));
        return stack;
    }
}

