/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfAssistance
extends ItemTablet {
    public ItemTabletOfAssistance() {
        super("tablet_of_assistance", () -> ConfigTombstone.allowedMagicItems.allowTabletOfAssistance());
        this.func_185043_a(new ResourceLocation("ancient"), (stack, worldIn, entityIn) -> this.isAncient(stack) ? 1.0f : 0.0f);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return EngravableHelper.getEngravedName(stack);
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String displayName = super.func_77653_i(stack);
        if (list.size() > 0) {
            list.set(0, displayName);
        } else {
            list.add(displayName);
        }
        if (Helper.canShowTooltip()) {
            boolean isAncient = this.isAncient(stack);
            boolean isEnchant = this.isEnchanted(stack);
            if (isAncient) {
                this.addItemDesc(list, "_ancient", new Object[0]);
                if (isEnchant) {
                    this.addItemUse(list, "_ancient", new Object[0]);
                } else {
                    this.addItemUse(list, "1", new Object[0]);
                }
            } else if (!isEnchant) {
                this.addItemDesc(list);
                this.addItemUse(list, "1", new Object[0]);
            } else {
                String engraved_name = EngravableHelper.getEngravedName(stack);
                if (engraved_name.isEmpty()) {
                    this.addItemDesc(list);
                    this.addItemUse(list, "2", StyleType.TOOLTIP_ITEM.func_150218_j() + "[" + ItemCraftingIngredient.IngredientType.GRAVE_DUST.getStack().func_82833_r() + "]");
                } else {
                    this.addInfo(list, LangKey.MESSAGE_ENGRAVED, "\"" + engraved_name + "\"");
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            this.setUseCount(stack, this.getUseMax());
            if (!this.isAncient(stack) && hasStrongSoul) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_TABLET.trigger(player);
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(WorldServer world, EntityPlayerMP player, ItemStack stack) {
        String engraved_name = EngravableHelper.getEngravedName(stack);
        if (engraved_name.isEmpty()) {
            boolean isAncient = this.isAncient(stack);
            if (!isAncient) {
                LangKey.MESSAGE_PLAYER_INVALID.sendMessage((ICommandSender)player, new Object[0]);
                return false;
            }
            List receivers = player.field_71133_b.func_184103_al().func_181057_v().stream().filter(p -> !p.equals((Object)player)).collect(Collectors.toList());
            if (receivers.size() == 0) {
                LangKey.MESSAGE_NO_OTHER_VALID_PLAYER.sendMessage((ICommandSender)player, new Object[0]);
                return false;
            }
            for (EntityPlayerMP receiver : receivers) {
                LangKey.MESSAGE_REQUEST_TO_HELP_SENDER.sendSpecialMessage((ICommandSender)receiver, LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.func_110124_au(), new Object[0]), player.func_70005_c_());
                CommandTBAcceptTeleport.addTicket((EntityPlayer)receiver, (EntityPlayer)player, 120, false);
            }
            LangKey.MESSAGE_CALL_FOR_HELP.sendMessage((ICommandSender)player, new Object[0]);
            ModTriggers.USE_ASSISTANCE.trigger(player);
            return true;
        }
        if (engraved_name.equals(player.func_70005_c_())) {
            LangKey.MESSAGE_TELEPORT_SAME_PLAYER.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        assert (world.func_73046_m() != null);
        if (Stream.of(world.func_73046_m().func_71213_z()).noneMatch(p -> p.equals(engraved_name))) {
            if (Arrays.asList(world.func_73046_m().func_152358_ax().func_152654_a()).contains(engraved_name)) {
                LangKey.MESSAGE_PLAYER_OFFLINE.sendWarnMessage((ICommandSender)player, new Object[0]);
            } else {
                LangKey.MESSAGE_PLAYER_INVALID.sendWarnMessage((ICommandSender)player, new Object[0]);
            }
            return false;
        }
        EntityPlayerMP receiver = world.func_73046_m().func_184103_al().func_152612_a(engraved_name);
        if (receiver == null) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        if (receiver.field_71093_bK != player.field_71093_bK && !ConfigTombstone.general.teleportDim) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        ITextComponent hereClick = LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.func_110124_au(), new Object[0]);
        LangKey.MESSAGE_REQUEST_TO_JOIN_RECEIVER.sendSpecialMessage((ICommandSender)receiver, hereClick, player.func_70005_c_());
        CommandTBAcceptTeleport.addTicket((EntityPlayer)receiver, (EntityPlayer)player, 120, false);
        LangKey.MESSAGE_REQUEST_TO_JOIN_SENDER.sendSpecialMessage((ICommandSender)player, receiver.func_70005_c_());
        ModTriggers.USE_ASSISTANCE.trigger(player);
        return true;
    }

    @Override
    protected boolean canBlockInteractFirst(IBlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || state.func_177230_c() instanceof BlockAnvil;
    }
}

