/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfCupidity
extends ItemTablet {
    public ItemTabletOfCupidity() {
        super("tablet_of_cupidity", () -> ConfigTombstone.allowedMagicItems.allowTabletOfCupidity());
        this.func_185043_a(new ResourceLocation("ancient"), (stack, worldIn, entityIn) -> this.isAncient(stack) ? 1.0f : 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            this.addItemDesc(list, this.isAncient(stack) ? "_ancient" : "_not_ancient", new Object[0]);
            this.addItemUse(list, this.isEnchanted(stack) ? "2" : "1", new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        if (stack.func_77973_b() == this) {
            this.setUseCount(stack, this.getUseMax());
            NBTStackHelper.setBoolean(stack, "enchant", true);
            if (!this.isAncient(stack) && hasStrongSoul) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_TABLET.trigger(player);
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(WorldServer world, EntityPlayerMP player, ItemStack stack) {
        Location spawnPos;
        TileEntity tile2;
        boolean isAncient = this.isAncient(stack);
        Predicate<TileEntity> predic = tile -> tile instanceof TileEntityChest && ((TileEntityLockableLoot)tile).field_184284_m != null;
        if (!isAncient) {
            predic = predic.or(tile -> tile instanceof TileEntityMobSpawner);
        }
        if ((tile2 = (TileEntity)Helper.getRandomInList(new CopyOnWriteArrayList(world.field_147482_g).stream().filter(predic).collect(Collectors.toList())).orElse(null)) != null && Helper.isValidPos((World)world, tile2.func_174877_v()) && !(spawnPos = new SpawnHelper(world, tile2.func_174877_v()).findSpawnPlace()).isOrigin()) {
            CallbackHandler.addFastCallback(() -> {
                EntityPlayerMP newPlayer = Helper.teleport(player, spawnPos);
                LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((ICommandSender)newPlayer, new Object[0]);
                if (!isAncient) {
                    Optional.ofNullable(newPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(newPlayer, 0, ConfigTombstone.alignment.pointsTabletOfCupidity));
                    EffectHelper.addRandomPotion((EntityPlayer)newPlayer, 1200, true, true, false);
                    if (Helper.RANDOM.nextInt(5) == 0 && world.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL) {
                        IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> Helper.spawnRandomMob(world, spawnPos.getPos()));
                    }
                }
                ModTriggers.USE_CUPIDITY.trigger(newPlayer);
            });
            return true;
        }
        LangKey.MESSAGE_TABLET_SEARCH_FAILED.sendMessage((ICommandSender)player, new Object[0]);
        return true;
    }
}

