/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfRecall
extends ItemTablet {
    public ItemTabletOfRecall() {
        super("tablet_of_recall", () -> ConfigTombstone.allowedMagicItems.allowTabletOfRecall());
        this.func_185043_a(new ResourceLocation("ancient"), (stack, worldIn, entityIn) -> this.isAncient(stack) ? 1.0f : 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            boolean isAncient = this.isAncient(stack);
            if (isAncient) {
                this.addItemDesc(list, "_ancient", new Object[0]);
            }
            if (!this.isEnchanted(stack)) {
                this.addItemUse(list, "1", new Object[0]);
            } else {
                Location location = this.getTombPos(stack);
                if (!location.isOrigin()) {
                    this.addItemPosition(list, location);
                    this.addItemUse(list, "2", new Object[0]);
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    private boolean setTombPos(ItemStack stack, Location location) {
        if (stack.func_77973_b() == this && !location.isOrigin()) {
            NBTStackHelper.setLocation(stack, "tombPos", location);
            return true;
        }
        return false;
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, "tombPos");
        }
        return Location.ORIGIN;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return !this.getTombPos(stack).isOrigin();
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        boolean valid = this.setTombPos(stack, new Location(gravePos, world));
        if (valid) {
            this.setUseCount(stack, this.getUseMax());
            if (!this.isAncient(stack) && hasStrongSoul) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_TABLET.trigger(player);
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ITEM_BOUND_TO_PLACE.getTranslation(new Object[0]);
    }

    @Override
    public void onSneakGrave(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && this.isEnchanted(stack) && !EntityHelper.hasGlobalItemCooldown(player, this)) {
            this.setTombPos(stack, new Location(gravePos, world));
            player.func_184811_cZ().func_185145_a((Item)this, 100);
            player.func_145747_a(this.getEnchantSuccessMessage(player).func_150255_a(StyleType.MESSAGE_NORMAL));
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    protected boolean doEffects(WorldServer world, EntityPlayerMP player, ItemStack stack) {
        Location location = this.getTombPos(stack);
        boolean isSameDim = location.isSameDimension((World)world);
        if (isSameDim && location.isInRange(player.func_180425_c(), 10)) {
            LangKey.MESSAGE_TELEPORT_TOO_CLOSE_FROM_GRAVE.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        if (!isSameDim && !ConfigTombstone.general.teleportDim) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        CallbackHandler.addCallback(1, () -> {
            boolean isAncient = this.isAncient(stack);
            AxisAlignedBB area = isAncient ? player.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0) : null;
            EntityPlayerMP newPlayer = Helper.teleport(player, location);
            if (isAncient) {
                List entities = world.func_72839_b((Entity)player, area);
                entities.forEach(entity -> Helper.teleport(entity, new Location((Entity)newPlayer)));
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newPlayer, new Object[0]);
            ModTriggers.USE_RECALL.trigger(player);
        });
        return true;
    }
}

