/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    private static final String POPPET_PROT_PREFIX = "poppet_prot_";

    public ItemVoodooPoppet() {
        super("voodoo_poppet", () -> ConfigTombstone.allowedMagicItems.allowVoodooPoppet());
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getServerTranslation(name) : name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            List<DamageType> damageTypes = this.getValidDamageTypes().filter(d -> this.hasProtection(stack, (DamageType)((Object)d))).collect(Collectors.toList());
            damageTypes.forEach(d -> list.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_ITEM, this.func_77658_a() + "." + d.func_176610_l(), new Object[0])));
            boolean enchanted = this.isEnchanted(stack);
            this.addItemUse(list, enchanted ? "3" : (damageTypes.isEmpty() ? "1" : "2"), new Object[0]);
            if (enchanted) {
                list.add(ModPerks.voodoo_poppet.getSpecialInfo(EntityHelper.getPerkLevelWithBonus((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ModPerks.voodoo_poppet)));
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_FAILED.getTranslation(new Object[0]);
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        if (!this.isEnchanted(stack) && this.getValidDamageTypes().anyMatch(p -> this.hasProtection(stack, (DamageType)((Object)p)))) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    public ItemStack createWithRandomProtections(int count) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(new ItemStack((Item)this), count), "enchant", true);
    }

    public Stream<DamageType> getValidDamageTypes() {
        return Arrays.stream(DamageType.values(), 0, DamageType.COLD.ordinal() + 1);
    }

    public Stream<DamageType> getCraftableDamageTypes() {
        return Arrays.stream(DamageType.values(), 0, DamageType.DARKNESS.ordinal() + 1);
    }

    public ItemStack addProtection(ItemStack stack, DamageType damageType) {
        if (stack.func_77973_b() == this && !this.isEnchanted(stack) && !this.hasProtection(stack, damageType)) {
            NBTStackHelper.setBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal(), true);
        }
        return stack;
    }

    private boolean hasProtection(ItemStack stack, DamageType damageType) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    public boolean preventDeath(EntityPlayerMP player, DamageSource source) {
        DamageType damageType = this.getPoppetProtection(source);
        if (damageType == null) {
            return false;
        }
        int chance = 50 + EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.voodoo_poppet) * 10;
        ItemStack voodooPoppet = InventoryHelper.findItemInMainInventory((EntityPlayer)player, p -> ModItems.voodoo_poppet.canPreventDeath((ItemStack)p, damageType));
        if (voodooPoppet.func_190926_b()) {
            return false;
        }
        if (Helper.RANDOM.nextInt(100) >= chance) {
            LangKey.MESSAGE_VOODOO_POPPET_PREVENT_DEATH_FAILED.sendSpecialMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        NBTStackHelper.removeKeyName(voodooPoppet, POPPET_PROT_PREFIX + damageType.ordinal());
        if (this.getValidDamageTypes().noneMatch(d -> this.hasProtection(voodooPoppet, (DamageType)((Object)d)))) {
            voodooPoppet.func_190918_g(1);
        }
        int duration = TimeHelper.tickFromSecond(ConfigTombstone.decorativeGrave.durationVoodooPoppetEffects);
        player.func_145747_a(LangKey.makeTranslationWithStyle(StyleType.MESSAGE_SPECIAL, "tombstone.message.prevent_death." + damageType.func_176610_l(), new Object[0]));
        ModTriggers.PREVENT_DEATH.get((Object)damageType).trigger(player);
        switch (damageType) {
            case SUFFOCATION: {
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, duration, 10, new boolean[0]);
                EffectHelper.addPotion((EntityLivingBase)player, ModEffects.aquatic_life, duration, 1, new boolean[0]);
                break;
            }
            case BURN: {
                player.func_70066_B();
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, duration, 10, new boolean[0]);
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76426_n, duration, 1, new boolean[0]);
                break;
            }
            case LIGHTNING: {
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, duration, 10, new boolean[0]);
                EffectHelper.addPotion((EntityLivingBase)player, ModEffects.lightning_resistance, duration, 1, new boolean[0]);
                break;
            }
            case FALL: {
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, duration, 10, new boolean[0]);
                EffectHelper.addPotion((EntityLivingBase)player, ModEffects.feather_fall, duration, 1, new boolean[0]);
                break;
            }
            case DARKNESS: {
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, duration, 10, new boolean[0]);
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76443_y, duration, 1, new boolean[0]);
                EffectHelper.clearBadEffects((EntityLivingBase)player);
                break;
            }
            case COLD: {
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, duration, 10, new boolean[0]);
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76424_c, duration, 1, new boolean[0]);
                EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76422_e, duration, 1, new boolean[0]);
                EffectHelper.clearBadEffects((EntityLivingBase)player);
                break;
            }
        }
        return true;
    }

    public boolean canPreventDeath(ItemStack stack, DamageType damageType) {
        return this.isEnchanted(stack) && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    @Nullable
    public DamageType getPoppetProtection(DamageSource srcDmg) {
        DamageType damageType = DamageType.of(srcDmg);
        return this.getValidDamageTypes().filter(d -> d == damageType).findFirst().orElse(null);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TBSoulConsumerProvider(this);
    }

    private ItemStack setRandomProtections(ItemStack stack, int count) {
        int limit = DamageType.COLD.ordinal() + 1;
        List<DamageType> damages = this.getValidDamageTypes().collect(Collectors.toList());
        if (count < limit) {
            ArrayList list = new ArrayList();
            for (int i = 0; i < count; ++i) {
                list.add(damages.remove(Helper.RANDOM.nextInt(damages.size())));
            }
            damages = list;
        }
        damages.forEach(d -> this.addProtection(stack, (DamageType)((Object)d)));
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, NBTTagCompound tag, LootContext context) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(stack, Helper.RANDOM.nextInt(5) + 1), "enchant", true);
    }
}

