/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collections;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;

public class PreciseEnchantFunction
extends LootFunction {
    private final String id;
    private final int level;

    private PreciseEnchantFunction(LootCondition[] conditionsIn, String id, int level) {
        super(conditionsIn);
        this.id = id;
        this.level = level;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        ResourceLocation rl = new ResourceLocation(this.id);
        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rl);
        if (enchant != null && (!"tombstone".equals(rl.func_110624_b()) || ((TombstoneEnchantment)enchant).isEnabled())) {
            EnchantmentHelper.func_82782_a(Collections.singletonMap(enchant, this.level), (ItemStack)stack);
            return stack;
        }
        return stack.func_77973_b() == Items.field_151134_bR ? ItemStack.field_190927_a : stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<PreciseEnchantFunction> {
        public Serializer() {
            super(new ResourceLocation("tombstone", "precise_enchant"), PreciseEnchantFunction.class);
        }

        public PreciseEnchantFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new PreciseEnchantFunction(conditionsIn, JsonUtils.func_151219_a((JsonObject)json, (String)"id", (String)"tombstone:soulbound"), JsonUtils.func_151208_a((JsonObject)json, (String)"level", (int)1));
        }

        public void serialize(JsonObject json, PreciseEnchantFunction functionClazz, JsonSerializationContext serializationContext) {
            json.addProperty("id", functionClazz.id);
            json.addProperty("level", (Number)functionClazz.level);
        }
    }
}

