/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;

public class SyncCooldownMessage
implements IMessage {
    private boolean isFullSync;
    private CooldownType type;
    private long worldTime;
    private NBTTagList cooldownTagList;

    public SyncCooldownMessage() {
    }

    public SyncCooldownMessage(CooldownType type, long worldTime) {
        this.isFullSync = false;
        this.type = type;
        this.worldTime = worldTime;
    }

    public SyncCooldownMessage(NBTTagList cooldownTagList) {
        this.isFullSync = true;
        this.cooldownTagList = cooldownTagList;
    }

    public void fromBytes(ByteBuf buf) {
        this.isFullSync = buf.readBoolean();
        if (this.isFullSync) {
            NBTTagCompound tag;
            try {
                tag = ByteBufUtils.readTag((ByteBuf)buf);
            }
            catch (Exception e) {
                tag = null;
            }
            this.cooldownTagList = tag != null && tag.func_150297_b("tb_cooldowns", 9) ? tag.func_150295_c("tb_cooldowns", 10) : new NBTTagList();
        } else {
            this.type = CooldownType.values()[buf.readByte()];
            this.worldTime = buf.readLong();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isFullSync);
        if (this.isFullSync) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("tb_cooldowns", (NBTBase)this.cooldownTagList);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        } else {
            buf.writeByte(this.type.ordinal());
            buf.writeLong(this.worldTime);
        }
    }

    public static class Handler
    implements IMessageHandler<SyncCooldownMessage, IMessage> {
        public IMessage onMessage(final SyncCooldownMessage message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Minecraft mainThread = Minecraft.func_71410_x();
                mainThread.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (message.isFullSync) {
                            CooldownHandler.INSTANCE.updateAllClientCooldowns(message.cooldownTagList);
                        } else {
                            CooldownHandler.INSTANCE.updateClientCooldown(message.type, message.worldTime);
                        }
                    }
                });
            }
            return null;
        }
    }
}

