/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.lang.ref.WeakReference;
import java.util.Optional;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.particle.CustomParticle;

@SideOnly(value=Side.CLIENT)
abstract class BoundParticle
extends CustomParticle {
    protected static final double TWO_PI = Math.PI * 2;
    protected final WeakReference<EntityLivingBase> entityWeakReference;
    private final double angle;
    private final double radius;
    private final double yHeight;

    BoundParticle(World world, EntityLivingBase entity, double angle, double radius, double yHeight) {
        super(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        this.entityWeakReference = new WeakReference<EntityLivingBase>(entity);
        this.angle = angle;
        this.radius = radius;
        this.yHeight = yHeight;
        this.func_187114_a(20);
    }

    protected void updatePosition() {
        this.updateLastPos();
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        Optional.ofNullable(this.entityWeakReference.get()).ifPresent(entity -> {
            double ratio = (double)(entity.field_70173_aa % 100) / 100.0;
            Vec3d vec = entity.func_174791_d().func_72441_c(this.radius * Math.cos(Math.PI * 2 * (this.angle + ratio)), this.yHeight, this.radius * Math.sin(Math.PI * 2 * (this.angle + ratio)));
            this.func_187109_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        });
    }

    @Override
    public void func_189213_a() {
        EntityLivingBase entity = (EntityLivingBase)this.entityWeakReference.get();
        if (entity == null || this.field_70546_d >= this.field_70547_e + 1) {
            this.func_187112_i();
            return;
        }
        ++this.field_70546_d;
        this.updatePosition();
        if (this.field_187129_i != 0.0 || this.field_187130_j != 0.0 || this.field_187131_k != 0.0) {
            this.func_187108_a(this.func_187116_l().func_72317_d(this.field_187129_i, this.field_187130_j, this.field_187131_k));
            this.func_187118_j();
        }
        this.update();
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.field_70546_d > 1) {
            super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        }
    }
}

