/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.util.function.Supplier;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.helper.Helper;

@SideOnly(value=Side.CLIENT)
abstract class CustomParticle
extends Particle {
    protected final float DEFAULT_ROLL = 0.31415927f;
    protected float rollIncrement = 0.0f;
    private boolean isSolid = false;
    private Supplier<Float> alphaSupplier = null;

    CustomParticle(World world, Vec3d vec) {
        this(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    CustomParticle(World world, double x, double y, double z) {
        this(world, x, y, z, 0.0, 0.0, 0.0);
    }

    CustomParticle(World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.field_190017_n = false;
    }

    protected boolean requireRemoval() {
        return this.field_70546_d >= this.field_70547_e;
    }

    public void func_189213_a() {
        this.updateLastPos();
        if (this.requireRemoval()) {
            this.func_187112_i();
        } else {
            ++this.field_70546_d;
            if (this.field_187129_i != 0.0 || this.field_187130_j != 0.0 || this.field_187131_k != 0.0) {
                this.func_187108_a(this.func_187116_l().func_72317_d(this.field_187129_i, this.field_187130_j, this.field_187131_k));
                this.func_187118_j();
            }
            this.update();
        }
    }

    protected void update() {
        if (this.rollIncrement > 0.0f) {
            this.field_190015_G = this.field_190014_F;
            this.field_190014_F += this.rollIncrement;
        }
        if (this.alphaSupplier != null) {
            this.field_82339_as = this.alphaSupplier.get().floatValue();
        }
    }

    protected void updateLastPos() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
    }

    public CustomParticle withColor(int color) {
        float[] colors = Helper.getRGBColor3F(color);
        this.func_70538_b(colors[0], colors[1], colors[2]);
        return this;
    }

    public void setSolid(boolean isSolid) {
        this.isSolid = isSolid;
    }

    public void func_82338_g(float alpha) {
        this.alphaSupplier = null;
        this.field_82339_as = alpha;
    }

    public void setAlphaF(Supplier<Float> alphaSupplier) {
        this.alphaSupplier = alphaSupplier;
        this.field_82339_as = alphaSupplier.get().floatValue();
    }

    public void setRolling(float rollIncrement) {
        this.setRolling((float)Math.PI * 2 * Helper.RANDOM.nextFloat(), rollIncrement);
    }

    public void setRolling(float rollStart, float rollIncrement) {
        if (rollIncrement != 0.0f) {
            this.field_190014_F = rollStart;
            this.rollIncrement = rollIncrement;
            this.field_190015_G = this.field_190014_F - this.rollIncrement;
        } else {
            this.field_190014_F = this.field_190015_G = rollStart;
            this.rollIncrement = 0.0f;
        }
    }

    public CustomParticle scale(float scale) {
        this.field_70544_f = scale * 2.0f;
        this.func_187115_a(this.field_70544_f, this.field_70544_f);
        return this;
    }

    @Deprecated
    public Particle func_70541_f(float scale) {
        return this.scale(scale);
    }

    public int func_189214_a(float partialTick) {
        return 0xF000F0;
    }

    public boolean func_187111_c() {
        return !this.isSolid;
    }

    public int func_70537_b() {
        return 1;
    }
}

