/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.CustomParticle;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;

@SideOnly(value=Side.CLIENT)
public class ParticleGraveSoul
extends CustomParticle {
    private static final TextureAtlasSprite COMMON_TEXTURE = Minecraft.func_71410_x().func_147117_R().func_110572_b("tombstone:items/soul");
    private static final double RADIUS = 0.3;
    private static final double SECTION = 1.5707963267948966;
    private final double centerX;
    private final double centerY;
    private final double centerZ;
    private final int part;

    public ParticleGraveSoul(World world, double centerX, double centerY, double centerZ, boolean hasStrongSoul, int part) {
        super(world, centerX, centerY, centerZ);
        this.func_187117_a(COMMON_TEXTURE);
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.part = part;
        this.func_187114_a(25);
        this.scale(hasStrongSoul ? 0.2f : 0.15f);
        float[] colorCode = Helper.getRGBColor3F(hasStrongSoul ? 65532 : 13710317);
        this.func_70538_b(colorCode[0], colorCode[1], colorCode[2]);
        this.func_82338_g(0.5f);
        this.updatePosition();
        this.updateLastPos();
    }

    private void updatePosition() {
        this.updateLastPos();
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        double ratio = (double)this.field_70546_d / (double)this.field_70547_e;
        Vec3d vec = new Vec3d(this.centerX + 0.3 * Math.cos(1.5707963267948966 * (ratio + (double)this.part)), this.centerY, this.centerZ + 0.3 * Math.sin(1.5707963267948966 * (ratio + (double)this.part)));
        this.func_187109_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    @Override
    public void update() {
        super.update();
        this.updatePosition();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleBlinkingAura(this.field_187122_b, this.field_187126_f, this.field_187127_g + 0.02, this.field_187128_h, this.field_70552_h, this.field_70553_i, this.field_70551_j));
    }
}

