/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.CustomParticle;

public class ParticleMarker
extends CustomParticle {
    private static final ResourceLocation WING_TEXTURE = new ResourceLocation("tombstone", "textures/items/revive.png");
    private static final ResourceLocation SPARK_TEXTURE = new ResourceLocation("tombstone", "textures/particles/glow.png");
    private static final ResourceLocation NOTE_TEXTURE = new ResourceLocation("tombstone", "textures/particles/note.png");

    public ParticleMarker(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scale, float[] colors) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.scale(scale);
        this.func_187114_a(40 + Helper.RANDOM.nextInt(10));
        this.func_70538_b(colors[0], colors[1], colors[2]);
        this.setSolid(true);
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        ResourceLocation rl;
        GlStateManager.func_179097_i();
        switch (ConfigTombstone.client.markerType) {
            case SPARK: {
                rl = SPARK_TEXTURE;
                break;
            }
            case NOTE: {
                rl = NOTE_TEXTURE;
                break;
            }
            default: {
                rl = WING_TEXTURE;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        float scale = this.field_70544_f * 0.1f;
        float x = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float y = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float z = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int light = this.func_189214_a(partialTicks);
        int l1 = light >> 16 & 0xFFFF;
        int l2 = light & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(-rotationYZ * scale - rotationXZ * scale)), new Vec3d((double)(-rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(-rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(rotationYZ * scale - rotationXZ * scale))};
        if (this.field_190014_F != 0.0f) {
            float roll = (float)Helper.lerp(partialTicks, this.field_190015_G, this.field_190014_F);
            float cosRoll = MathHelper.func_76134_b((float)(roll * 0.5f));
            Vec3d vec3d = new Vec3d((double)(MathHelper.func_76126_a((float)(roll * 0.5f)) * (float)ParticleMarker.field_190016_K.field_72450_a), (double)(MathHelper.func_76126_a((float)(roll * 0.5f)) * (float)ParticleMarker.field_190016_K.field_72448_b), (double)(MathHelper.func_76126_a((float)(roll * 0.5f)) * (float)ParticleMarker.field_190016_K.field_72449_c));
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(cosRoll * cosRoll) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a(2.0 * (double)cosRoll));
            }
        }
        buffer.func_181662_b((double)x + avec3d[0].field_72450_a, (double)y + avec3d[0].field_72448_b, (double)z + avec3d[0].field_72449_c).func_187315_a((double)u1, (double)v1).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(l1, l2).func_181675_d();
        buffer.func_181662_b((double)x + avec3d[1].field_72450_a, (double)y + avec3d[1].field_72448_b, (double)z + avec3d[1].field_72449_c).func_187315_a((double)u1, (double)v0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(l1, l2).func_181675_d();
        buffer.func_181662_b((double)x + avec3d[2].field_72450_a, (double)y + avec3d[2].field_72448_b, (double)z + avec3d[2].field_72449_c).func_187315_a((double)u0, (double)v0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(l1, l2).func_181675_d();
        buffer.func_181662_b((double)x + avec3d[3].field_72450_a, (double)y + avec3d[3].field_72448_b, (double)z + avec3d[3].field_72449_c).func_187315_a((double)u0, (double)v1).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(l1, l2).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179126_j();
    }

    @Override
    public int func_70537_b() {
        return 3;
    }
}

