/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="tombstone", value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class TombstoneParticleSprites {
    private static final EnumMap<SpriteTypes, TextureAtlasSprite> sprites = new EnumMap(SpriteTypes.class);

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        for (SpriteTypes spriteType : SpriteTypes.values()) {
            sprites.put(spriteType, event.getMap().func_174942_a(new ResourceLocation("tombstone", "particles/" + spriteType.name().toLowerCase(Locale.US))));
        }
    }

    public static TextureAtlasSprite getSprite(SpriteTypes particleType) {
        TextureAtlasSprite sprite = sprites.get((Object)particleType);
        if (sprite == null) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b("missingno");
        }
        return sprite;
    }

    public static enum SpriteTypes {
        FAKE_FOG,
        GHOST,
        BONE;


        public void setTexture(Particle particle) {
            particle.func_187117_a(TombstoneParticleSprites.getSprite(this));
        }
    }
}

