/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

public class PerkJailer
extends Perk {
    PerkJailer() {
        super("jailer", new ResourceLocation("tombstone", "textures/items/grave_key.png"));
    }

    @Override
    public int getLevelMax() {
        return 5 - ConfigTombstone.general.getChanceEnchantedGraveKey() / 20;
    }

    @Override
    public boolean isDisabled(@Nullable EntityPlayer player) {
        return ConfigTombstone.general.getChanceEnchantedGraveKey() == -1 || ConfigTombstone.general.getChanceEnchantedGraveKey() == 100;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return "+" + level * 20 + "% " + this.getDescription();
        }
        if (level == actualLevel + 1) {
            return "+" + level * 20 + "%";
        }
        return "";
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        return TimeHelper.isDateAroundHalloween() ? 5 : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_ACTUAL_BONUS.getClientTranslation(ConfigTombstone.general.getChanceEnchantedGraveKey() + levelWithBonus * 20);
    }
}

