/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;

public class PerkMementoMori
extends Perk {
    PerkMementoMori() {
        super("memento_mori", new ResourceLocation("minecraft", "textures/items/experience_bottle.png"));
    }

    @Override
    public int getLevelMax() {
        return ConfigTombstone.player_death.getXpLoss() / 20;
    }

    @Override
    public boolean isDisabled(@Nullable EntityPlayer player) {
        return ConfigTombstone.player_death.getXpLoss() < 20;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return "+" + level * 20 + "% " + this.getDescription();
        }
        if (level == actualLevel + 1) {
            return "+" + level * 20 + "%";
        }
        return "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_ACTUAL_BONUS.getClientTranslation(100 - ConfigTombstone.player_death.getXpLoss() + levelWithBonus * 20);
    }
}

