/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

public class PerkVoodooPoppet
extends Perk {
    PerkVoodooPoppet() {
        super("voodoo_poppet", new ResourceLocation("tombstone", "textures/items/voodoo_poppet.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled(@Nullable EntityPlayer player) {
        return !ConfigTombstone.allowedMagicItems.allowVoodooPoppet();
    }

    @Override
    public String getTranslationKey() {
        return "tombstone.item.voodoo_poppet.name";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return "+" + level * 10 + "% " + this.getDescription();
        }
        if (level == actualLevel + 1) {
            return "+" + level * 10 + "%";
        }
        return "";
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        return TimeHelper.isDateAroundHalloween() ? 5 : 0;
    }

    @Override
    public String getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_CHANCE_TRIGGER.getClientTranslation(50 + levelWithBonus * 10);
    }
}

