/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.proxy;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.CustomStateMapper;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.command.CommandTBGui;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.event.ClientEventHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.item.ICustomModel;
import ovh.corail.tombstone.particle.ParticleBoneShield;
import ovh.corail.tombstone.particle.ParticleCasting;
import ovh.corail.tombstone.particle.ParticleGraveSmoke;
import ovh.corail.tombstone.particle.ParticleGraveSoul;
import ovh.corail.tombstone.particle.ParticleShadowStep;
import ovh.corail.tombstone.particle.ParticleShield;
import ovh.corail.tombstone.particle.ParticleSmokeColumn;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.RegistryHandler;
import ovh.corail.tombstone.render.RenderWritableGrave;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
implements IProxy {
    @Override
    public void init(FMLInitializationEvent event) {
        Helper.checkDeathHandlingMod(null).ifPresent(modName -> {
            throw new CustomModLoadingErrorDisplayException("Conflicting Mod Exception", new RuntimeException("You loaded a conflicting mod handling the player's death (" + modName + ").")){

                public void initGui(GuiErrorScreen parent, FontRenderer fontRenderer) {
                }

                public void drawScreen(GuiErrorScreen parent, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
                    parent.func_73732_a(parent.field_146297_k.field_71466_p, "Conflicting Mod Exception : ", parent.field_146294_l / 2, 90, 0xFFFFFF);
                    parent.func_73732_a(parent.field_146297_k.field_71466_p, this.getMessage(), parent.field_146294_l / 2, 110, 0xFFFFFF);
                }
            };
        });
        ClientRegistry.registerKeyBinding((KeyBinding)ClientEventHandler.KEYBIND_KNOWLEDGE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWritableGrave.class, (TileEntitySpecialRenderer)new RenderWritableGrave());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTBGui());
    }

    @Override
    public void produceGraveSmoke(World world, BlockPos pos) {
        if (ConfigTombstone.client.fogDensity != ConfigTombstone.CatClient.FogDensity.NONE) {
            for (int i = 0; i <= ConfigTombstone.client.fogDensity.ordinal(); ++i) {
                ParticleGraveSmoke particle = new ParticleGraveSmoke(world, (double)pos.func_177958_n() + world.field_73012_v.nextGaussian(), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian(), (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.03, 0.0, (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.03);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    @Override
    public void produceShadowStep(EntityLivingBase entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        if (mc.field_71439_g != null && mc.field_71439_g.equals((Object)entity) && mc.field_71474_y.field_74320_O == 0) {
            return;
        }
        if (mc.field_71441_e != null && !entity.func_184218_aH() && !entity.func_70608_bn()) {
            IntStream.rangeClosed(1, 6).forEach(i -> mc.field_71452_i.func_78873_a((Particle)new ParticleShadowStep(mc.field_71441_e, entity, (double)i / 6.0)));
        }
    }

    @Override
    public void produceShield(EntityLivingBase entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.func_147113_T() || mc.field_71441_e == null || entity.func_184218_aH() || entity.func_70608_bn())) {
            IntStream.rangeClosed(1, 4).forEach(i -> mc.field_71452_i.func_78873_a((Particle)new ParticleShield(mc.field_71441_e, entity, 0.25 * (double)i)));
        }
    }

    @Override
    public void produceBoneShield(EntityLivingBase entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !entity.func_184218_aH() && !entity.func_70608_bn()) {
            IntStream.rangeClosed(1, 5).forEach(i -> mc.field_71452_i.func_78873_a((Particle)new ParticleBoneShield(mc.field_71441_e, entity, 0.2 * (double)i, i % 2 == 0)));
        }
    }

    @Override
    public void produceGraveSoul(World world, BlockPos pos, boolean hasStrongSoul, int part) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_147113_T() && mc.func_175598_ae().func_78714_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 1024.0) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleGraveSoul(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.85, (double)pos.func_177952_p() + 0.5, hasStrongSoul, part));
        }
    }

    @Override
    public void produceParticleCasting(EntityLivingBase caster, Predicate<EntityLivingBase> predic) {
        if (caster != null) {
            for (int i = 1; i <= 2; ++i) {
                ParticleCasting particle = new ParticleCasting(caster.field_70170_p, caster, predic, 0.0, (double)i * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 0.5, (double)(i + 1) * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 1.0, (double)i * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 1.5, (double)(i + 1) * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 2.0, (double)i * 0.5);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    @Override
    public void produceSmokeColumn(World world, double x, double y, double z) {
        for (int i = 0; i < 6; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn(world, x - 0.1, y, z - 0.1, i));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn(world, x - 0.1, y, z + 0.1, i));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn(world, x + 0.1, y, z - 0.1, i));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSmokeColumn(world, x + 0.1, y, z + 0.1, i));
        }
    }

    @Override
    public void registerModels() {
        for (BlockGrave blockGrave : RegistryHandler.graves) {
            ModelLoader.setCustomStateMapper((Block)blockGrave, (IStateMapper)new CustomStateMapper());
        }
        for (BlockGraveBase blockGraveBase : RegistryHandler.decorative_graves) {
            ModelLoader.setCustomStateMapper((Block)blockGraveBase, (IStateMapper)new CustomStateMapper());
            ((ItemBlockGrave)Item.func_150898_a((Block)blockGraveBase)).initModel();
        }
        Optional.ofNullable(ModBlocks.dark_marble.getRegistryName()).ifPresent(rl -> {
            Item item = Item.func_150898_a((Block)ModBlocks.dark_marble);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(rl, "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(rl, "inventory2"));
        });
        for (BlockGraveBase blockGraveBase : RegistryHandler.items) {
            if (blockGraveBase instanceof ICustomModel) {
                ((ICustomModel)((Object)blockGraveBase)).registerModels();
                continue;
            }
            assert (blockGraveBase.getRegistryName() != null);
            ModelLoader.setCustomModelResourceLocation((Item)blockGraveBase, (int)0, (ModelResourceLocation)new ModelResourceLocation(blockGraveBase.getRegistryName(), "inventory"));
        }
    }
}

