/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.enchantment.EnchantmentBlessing;
import ovh.corail.tombstone.enchantment.EnchantmentCurseOfBones;
import ovh.corail.tombstone.enchantment.EnchantmentMagicSiphon;
import ovh.corail.tombstone.enchantment.EnchantmentPlagueBringer;
import ovh.corail.tombstone.enchantment.EnchantmentShadowStep;
import ovh.corail.tombstone.enchantment.EnchantmentSoulBound;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;

@Mod.EventBusSubscriber(modid="tombstone")
public class ModEnchantments {
    public static final TombstoneEnchantment shadow_step = new EnchantmentShadowStep();
    public static final TombstoneEnchantment soulbound = new EnchantmentSoulBound();
    public static final TombstoneEnchantment magic_siphon = new EnchantmentMagicSiphon();
    public static final TombstoneEnchantment plague_bringer = new EnchantmentPlagueBringer();
    public static final TombstoneEnchantment blessing = new EnchantmentBlessing();
    public static final TombstoneEnchantment curse_of_bones = new EnchantmentCurseOfBones();
    private static final Map<String, TombstoneEnchantment> ENCHANTMENTS = new HashMap<String, TombstoneEnchantment>();

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), shadow_step);
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), soulbound);
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), magic_siphon);
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), plague_bringer);
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), blessing);
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), curse_of_bones);
    }

    private static void registerEnchantment(IForgeRegistry<Enchantment> registry, TombstoneEnchantment enchantment) {
        registry.register((IForgeRegistryEntry)enchantment);
        ENCHANTMENTS.put(Objects.requireNonNull(enchantment.getRegistryName()).toString(), enchantment);
    }

    public static Map<String, TombstoneEnchantment> getEnchantments() {
        return ENCHANTMENTS;
    }
}

