/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@SideOnly(value=Side.CLIENT)
public class RenderWritableGrave
extends TileEntitySpecialRenderer<TileEntityWritableGrave> {
    public void render(TileEntityWritableGrave te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean renderHalloween;
        if (te == null || !te.func_145830_o()) {
            return;
        }
        boolean bl = renderHalloween = ConfigTombstone.client.graveSkinRule == ConfigTombstone.CatClient.GraveSkinRule.FORCE_HALLOWEEN || TimeHelper.isDateAroundHalloween() && ConfigTombstone.client.graveSkinRule != ConfigTombstone.CatClient.GraveSkinRule.FORCE_NORMAL;
        if (!te.hasOwner() && !renderHalloween) {
            return;
        }
        IBlockState knownState = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!ModBlocks.isAnyGrave(knownState.func_177230_c())) {
            return;
        }
        EnumFacing facing = (EnumFacing)knownState.func_177229_b((IProperty)BlockGraveBase.FACING);
        BlockGraveBase grave = (BlockGraveBase)knownState.func_177230_c();
        GraveModel graveModel = grave.getGraveType();
        BlockGraveMarble.MarbleType marbleType = BlockGraveMarble.MarbleType.byId((Integer)knownState.func_177229_b((IProperty)BlockGraveBase.MODEL_TEXTURE));
        if (renderHalloween) {
            this.renderHalloween(x, y, z, graveModel, marbleType, facing, partialTicks);
        }
        if (!te.hasOwner()) {
            return;
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179114_b((float)(90.0f * (float)(this.getRotationIndex(facing) - 2)), (float)0.0f, (float)1.0f, (float)0.0f);
        if (graveModel == GraveModel.GRAVE_CROSS) {
            GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.26f, (float)0.07f);
        } else {
            switch (graveModel) {
                case GRAVE_SIMPLE: {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.4f, (float)-0.29f);
                    break;
                }
                case GRAVE_NORMAL: {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)-0.36f);
                    break;
                }
                case TOMBSTONE: {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.23f, (float)0.08f);
                    break;
                }
                case SUBARAKI_GRAVE: {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.62f, (float)0.14f);
                    break;
                }
                case GRAVE_ORIGINAL: {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.51f);
                    break;
                }
            }
        }
        GlStateManager.func_179132_a((boolean)false);
        FontRenderer fontRender = this.func_147498_b();
        boolean is_original = graveModel == GraveModel.GRAVE_ORIGINAL;
        GlStateManager.func_179094_E();
        float scale = 0.007f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        this.showString(TextFormatting.BOLD + LangKey.MESSAGE_RIP.getClientTranslation(new Object[0]), fontRender, is_original ? 8 : 0, ConfigTombstone.client.textColorRIP + -16777216);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        scale = 0.005f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        this.showString(TextFormatting.BOLD + te.getOwnerName(), fontRender, is_original ? 14 : 11, ConfigTombstone.client.textColorOwner + -16777216);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        scale = is_original ? 0.003f : (ConfigTombstone.client.dateInMCTime ? 0.005f : 0.004f);
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        int textColorDeathDate = ConfigTombstone.client.textColorDeathDate + -16777216;
        this.showString(TextFormatting.BOLD + LangKey.MESSAGE_DIED_ON.getClientTranslation(new Object[0]), fontRender, 26, textColorDeathDate);
        if (ConfigTombstone.client.dateInMCTime) {
            long days = te.getDeathMCTime() / 24000L;
            String dateString = LangKey.MESSAGE_DAY.getClientTranslation(days);
            this.showString(TextFormatting.BOLD + dateString, fontRender, 36, textColorDeathDate);
        } else {
            Date date = new Date(te.getOwnerDeathTime());
            String dateString = new SimpleDateFormat("dd/MM/yyyy").format(date);
            String timeString = LangKey.MESSAGE_DEATH_TIME.getClientTranslation(new SimpleDateFormat("HH:mm:ss").format(date));
            this.showString(TextFormatting.BOLD + dateString, fontRender, 36, textColorDeathDate);
            this.showString(TextFormatting.BOLD + timeString, fontRender, 46, textColorDeathDate);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderHalloween(double x, double y, double z, GraveModel graveModel, BlockGraveMarble.MarbleType marbleType, EnumFacing facing, float partialTicks) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179114_b((float)(90.0f * (float)this.getRotationIndex(facing)), (float)0.0f, (float)1.0f, (float)0.0f);
        if (graveModel == GraveModel.GRAVE_NORMAL || graveModel == GraveModel.GRAVE_SIMPLE) {
            if (graveModel == GraveModel.GRAVE_SIMPLE) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.21f, (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)0.41f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(new ItemStack(Helper.isNight(this.func_178459_a()) ? Blocks.field_150428_aP : Blocks.field_150423_aK), ItemCameraTransforms.TransformType.NONE);
        } else {
            if (graveModel == GraveModel.SUBARAKI_GRAVE) {
                GlStateManager.func_179109_b((float)-0.35f, (float)0.44f, (float)-0.35f);
            } else if (graveModel == GraveModel.GRAVE_CROSS) {
                GlStateManager.func_179109_b((float)0.2f, (float)0.07f, (float)0.0f);
            } else if (graveModel == GraveModel.TOMBSTONE) {
                GlStateManager.func_179109_b((float)-0.2f, (float)0.65f, (float)-0.2f);
            } else {
                GlStateManager.func_179109_b((float)-0.575f, (float)0.07f, (float)-0.35f);
            }
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
            TileEntitySkullRenderer.field_147536_b.func_188190_a(0.0f, 0.0f, 0.0f, EnumFacing.UP, 0.0f, 0, null, -1, 0.0f);
        }
        GlStateManager.func_179121_F();
    }

    private void showString(String content, FontRenderer fontRenderer, int posY, int color) {
        fontRenderer.func_175065_a(content, (float)(-fontRenderer.func_78256_a(content)) / 2.0f, (float)(posY - 30), color, true);
    }

    private int getRotationIndex(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 1;
            }
            case EAST: {
                return 3;
            }
        }
        return 0;
    }
}

