/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityDecorativeGrave
extends TileEntityWritableGrave {
    private long lastCheckSoul = -1L;
    private boolean hasStrongSoul = false;

    @Override
    public boolean canShowFog() {
        return this.field_145850_b != null && ConfigTombstone.client.fogPeriod.test(this.field_145850_b);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || !ModBlocks.isDecorativeGrave(this.func_145838_q())) {
            return;
        }
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            IBlockState state;
            if (TimeHelper.atInterval(this.countTicks, 25) && ModBlocks.isDecorativeGrave((state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c()) && ((Boolean)state.func_177229_b((IProperty)BlockGraveBase.HAS_SOUL)).booleanValue()) {
                ModTombstone.PROXY.produceGraveSoul(this.field_145850_b, this.field_174879_c, this.hasStrongSoul, (int)((long)this.countTicks % 100L) / 25);
            }
        } else {
            long worldTicks = TimeHelper.worldTicks(this.field_145850_b);
            if (this.lastCheckSoul <= 0L || this.lastCheckSoul > worldTicks) {
                this.lastCheckSoul = worldTicks;
                return;
            }
            long elapsedMinutes = TimeHelper.minuteElapsed(this.field_145850_b, this.lastCheckSoul);
            if (elapsedMinutes >= (long)ConfigTombstone.decorativeGrave.timeSoul) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                if (((Boolean)state.func_177229_b((IProperty)BlockGraveBase.HAS_SOUL)).booleanValue()) {
                    this.resetCheckSoul();
                    return;
                }
                long count = elapsedMinutes / (long)ConfigTombstone.decorativeGrave.timeSoul;
                this.lastCheckSoul += count * (long)ConfigTombstone.decorativeGrave.timeSoul;
                double chance = 1.0 - Math.pow(1.0 - (double)ConfigTombstone.decorativeGrave.chanceSoul / 1000.0, count);
                if (chance >= 1.0 || Helper.RANDOM.nextDouble() <= chance) {
                    if (elapsedMinutes == (long)ConfigTombstone.decorativeGrave.timeSoul) {
                        this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), true));
                    }
                    this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)BlockGraveBase.HAS_SOUL, (Comparable)Boolean.valueOf(true)), 3);
                    this.hasStrongSoul = Helper.RANDOM.nextFloat() < (TimeHelper.isDateAroundHalloween() ? 0.2f : 0.05f);
                }
            }
        }
    }

    public boolean hasStrongSoul() {
        return this.hasStrongSoul;
    }

    public void removeStrongSoul() {
        this.hasStrongSoul = false;
    }

    public void resetCheckSoul() {
        this.lastCheckSoul = -1L;
    }

    @Override
    protected NBTTagCompound writeShared(NBTTagCompound compound) {
        super.writeShared(compound);
        if (this.lastCheckSoul > 0L) {
            compound.func_74772_a("lastCheckSoul", this.lastCheckSoul);
        }
        compound.func_74757_a("hasStrongSoul", this.hasStrongSoul);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("lastCheckSoul", 4)) {
            this.lastCheckSoul = compound.func_74763_f("lastCheckSoul");
        }
        this.hasStrongSoul = compound.func_74767_n("hasStrongSoul");
    }
}

