/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityPlayerGrave
extends TileEntityWritableGrave {
    protected final ItemStackHandler inventory = new ItemStackHandler(120);
    @Nullable
    private UUID ownerId = null;
    protected boolean needAccess = false;

    @Override
    public boolean canShowFog() {
        return true;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void giveInventory(EntityPlayerMP player) {
        boolean hasLosses;
        if (this.field_145850_b == null || !EntityHelper.isValidServerPlayer((Entity)player)) {
            return;
        }
        assert (player.func_184102_h() != null);
        boolean bl = hasLosses = ConfigTombstone.player_death.chanceLossOnDeath > 0 && ConfigTombstone.player_death.percentLossOnDeath > 0 && (!ConfigTombstone.player_death.lossOnDeathOnlyForAbandonedGrave || !this.getNeedAccess()) && Helper.getRandom(1, 100) <= ConfigTombstone.player_death.chanceLossOnDeath;
        if (hasLosses) {
            float percentLossOnDeath = (float)ConfigTombstone.player_death.percentLossOnDeath * 0.01f;
            int countLoss = 0;
            for (int slotId = 0; slotId < this.inventory.getSlots(); ++slotId) {
                ItemStack stack2 = this.inventory.getStackInSlot(slotId);
                if (stack2.func_190926_b()) continue;
                if (stack2.func_77985_e()) {
                    int losses;
                    if (stack2.func_77942_o() && ConfigTombstone.player_death.lossOnDeathOnlyForStackableItems || (losses = Math.round((float)stack2.func_190916_E() * percentLossOnDeath)) <= 0) continue;
                    this.inventory.extractItem(slotId, losses, false);
                    ++countLoss;
                    continue;
                }
                if (ConfigTombstone.player_death.lossOnDeathOnlyForStackableItems || !(Helper.RANDOM.nextFloat() <= percentLossOnDeath)) continue;
                this.inventory.setStackInSlot(slotId, ItemStack.field_190927_a);
                ++countLoss;
            }
            if (countLoss > 0) {
                ItemStack junkStack = TimeHelper.isDateAroundHalloween() ? new ItemStack(ModItems.lollipop, Helper.getRandom(1, 3), Helper.getRandom(0, 4)) : (countLoss > 5 ? ItemCraftingIngredient.IngredientType.GRAVE_DUST.getStack() : (countLoss > 2 ? new ItemStack(Items.field_151055_y) : new ItemStack((Block)Blocks.field_150330_I)));
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)junkStack);
                LangKey.MESSAGE_LOSSES_ON_DEATH.sendSpecialMessage((ICommandSender)player, new Object[0]);
            }
        }
        EventFactory.onRestoreInventory((EntityPlayer)player, this);
        PlayerPreference playerPreference = PlayerPreference.get(player.func_110124_au());
        if (playerPreference.getAutoEquipRule().equiOnGraveRecovery()) {
            for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                if (!ovh.corail.tombstone.helper.InventoryHelper.autoequip(this.inventory.getStackInSlot(i), (EntityPlayer)player)) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
        NonNullList swapItems = NonNullList.func_191196_a();
        if (playerPreference.priorizeToolOnHotbar()) {
            IItemHandler cap = ovh.corail.tombstone.helper.InventoryHelper.getItemHandler((Entity)player);
            int playerSlotId = -1;
            for (int graveSlotId = 0; graveSlotId < this.inventory.getSlots() && playerSlotId < 9; ++graveSlotId) {
                ItemStack playerStack;
                if (!ovh.corail.tombstone.helper.InventoryHelper.isTool(this.inventory.getStackInSlot(graveSlotId))) continue;
                do {
                    playerStack = cap.getStackInSlot(++playerSlotId);
                } while (playerSlotId < 9 && ovh.corail.tombstone.helper.InventoryHelper.isTool(playerStack));
                if (playerStack.func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.inventory.extractItem(graveSlotId, 1, false), (int)playerSlotId);
                } else {
                    swapItems.add((Object)cap.extractItem(playerSlotId, 1, false));
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.inventory.extractItem(graveSlotId, 1, false), (int)playerSlotId);
                }
                this.inventory.setStackInSlot(graveSlotId, ItemStack.field_190927_a);
            }
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack3 = this.inventory.getStackInSlot(i);
            if (stack3.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack3.func_77946_l());
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (!swapItems.isEmpty()) {
            swapItems.forEach(stack -> ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack));
            swapItems.clear();
        }
        this.removeGraveBy(player);
        EffectHelper.capDuration((EntityLivingBase)player, ModEffects.ghostly_shape, 100);
        player.field_71069_bz.func_75142_b();
        LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
    }

    private void removeGraveBy(EntityPlayerMP player) {
        EntityPlayerMP owner;
        if (this.field_145850_b == null) {
            return;
        }
        EntityPlayerMP entityPlayerMP = owner = player.func_146103_bH().getName().equals(this.ownerName) ? player : (EntityPlayerMP)Optional.ofNullable(player.func_184102_h()).map(MinecraftServer::func_184103_al).map(list -> list.func_152612_a(this.ownerName)).orElse(null);
        if (owner != null) {
            DeathHandler.INSTANCE.removeGrave(owner, new Location(this.field_174879_c, this.field_145850_b));
        }
        Helper.removeNoEvent(this.field_145850_b, this.field_174879_c);
        this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public <T extends Entity> void setOwner(T owner, long deathDate, boolean needAccess) {
        super.setOwner(owner, deathDate);
        this.ownerId = owner.func_110124_au();
        this.needAccess = needAccess;
    }

    public boolean isOwner(EntityPlayer owner) {
        return this.ownerId == null ? this.hasOwner() && this.ownerName.equals(owner.func_146103_bH().getName()) : this.ownerId.equals(owner.func_110124_au());
    }

    public boolean getNeedAccess() {
        return this.needAccess && (ConfigTombstone.player_death.getDecayTime() == -1 || this.getDeathMCTime() < (long)TimeHelper.tickFromMinute(ConfigTombstone.player_death.getDecayTime()));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    @Override
    protected NBTTagCompound writeShared(NBTTagCompound compound) {
        super.writeShared(compound);
        if (this.ownerId != null) {
            compound.func_186854_a("owner_id", this.ownerId);
        }
        compound.func_74757_a("needAccess", this.needAccess);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("inventory", 10)) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_186855_b("owner_id")) {
            this.ownerId = compound.func_186857_a("owner_id");
        }
        this.needAccess = compound.func_74767_n("needAccess");
    }

    public boolean func_183000_F() {
        return true;
    }

    public void func_145843_s() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !ModBlocks.isPlayerGrave(this.field_145850_b, this.field_174879_c) && Helper.isAllowedForRemoval(this.field_145850_b, this.field_174879_c)) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inventory.extractItem(i, stack.func_190916_E(), false));
            }
        }
        super.func_145843_s();
    }

    @Override
    public boolean isPlayerGrave() {
        return true;
    }

    public String getFormattedInfo() {
        StringBuilder builder = new StringBuilder(TextFormatting.GOLD.toString()).append(LangKey.MESSAGE_RIP.getServerTranslation(new Object[0])).append(" ").append(this.getOwnerName()).append(" ");
        if (this.getNeedAccess()) {
            int left;
            builder.append(TextFormatting.RED).append("[").append(LangKey.MESSAGE_LOCKED.getServerTranslation(new Object[0])).append("]");
            int decayTime = ConfigTombstone.player_death.getDecayTime();
            if (decayTime > 0 && (left = TimeHelper.tickFromMinute(decayTime) - (int)this.getDeathMCTime()) > 0) {
                builder.append(" ").append(TimeHelper.getTimeStringWithUnit(left));
            }
        } else {
            builder.append(TextFormatting.GREEN).append("[").append(LangKey.MESSAGE_UNLOCKED.getServerTranslation(new Object[0])).append("]");
        }
        return builder.toString();
    }

    public String getFormattedDeathDate() {
        Date date = new Date(this.getOwnerDeathTime());
        return TextFormatting.ITALIC + LangKey.MESSAGE_DIED_ON.getServerTranslation(new Object[0]) + " " + new SimpleDateFormat("dd/MM/yyyy").format(date) + " " + LangKey.MESSAGE_DEATH_TIME.getServerTranslation(new SimpleDateFormat("HH:mm:ss").format(date));
    }
}

