/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public abstract class TileEntityWritableGrave
extends TileEntity
implements ITickable {
    protected String ownerName = "";
    protected long deathDate;
    protected long deathMCTime = 0L;
    public int countTicks = 0;

    public abstract boolean canShowFog();

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            ++this.countTicks;
            if (this.field_145850_b.field_72995_K) {
                if (this.canShowFog()) {
                    ModTombstone.PROXY.produceGraveSmoke(this.field_145850_b, this.field_174879_c);
                }
            } else if (TimeHelper.isAprilFoolsDay() && TimeHelper.atInterval(this.countTicks, 600) && Helper.RANDOM.nextFloat() < 0.3f) {
                Helper.handleAprilFoolsDayGrave(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public <T extends Entity> void setOwner(T owner, long deathDate) {
        this.setOwner(owner.func_145748_c_().func_150260_c(), deathDate);
    }

    public void setOwner(String ownerName, long deathDate) {
        this.ownerName = ownerName;
        this.deathDate = deathDate;
        this.deathMCTime = Optional.ofNullable(this.field_145850_b).map(TimeHelper::worldTicks).orElse(0L);
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean hasOwner() {
        return this.ownerName.length() > 0;
    }

    public long getDeathMCTime() {
        return Optional.ofNullable(this.field_145850_b).map(thisWorld -> {
            long worldTicks = TimeHelper.worldTicks(thisWorld);
            if (this.deathMCTime > worldTicks) {
                this.deathMCTime = worldTicks;
            }
            return worldTicks - this.deathMCTime;
        }).orElse(0L);
    }

    public void resetDeathTime() {
        this.deathDate = TimeHelper.systemTime();
        this.countTicks = 0;
    }

    public long getOwnerDeathTime() {
        return this.deathDate;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return this.writeShared(compound);
    }

    protected NBTTagCompound writeShared(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74772_a("deathMCTime", this.deathMCTime);
        compound.func_74768_a("countTicks", this.countTicks);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("ownerName", 8)) {
            this.ownerName = compound.func_74779_i("ownerName");
        }
        if (compound.func_150297_b("deathDate", 4)) {
            this.deathDate = compound.func_74763_f("deathDate");
        }
        if (compound.func_150297_b("deathMCTime", 4)) {
            this.deathMCTime = compound.func_74763_f("deathMCTime");
        }
        if (compound.func_150297_b("countTicks", 3)) {
            this.countTicks = compound.func_74762_e("countTicks");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeShared(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public boolean func_145842_c(int id, int type) {
        return true;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtension = 1.0;
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtension, (double)this.field_174879_c.func_177956_o() - renderExtension, (double)this.field_174879_c.func_177952_p() - renderExtension, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtension, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtension, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtension);
    }

    public boolean isPlayerGrave() {
        return false;
    }
}

