/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet.gui;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.mc.ContainerSub;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerControlUpdatePacket
extends CreativeCorePacket {
    public NBTTagCompound value;
    public String name;
    public int layer;

    public ContainerControlUpdatePacket() {
    }

    public ContainerControlUpdatePacket(int layer, String name, NBTTagCompound value) {
        this.value = value;
        this.name = name;
        this.layer = layer;
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        ContainerControlUpdatePacket.writeNBT(bytes, this.value);
        bytes.writeBoolean(this.name != null);
        if (this.name != null) {
            ContainerControlUpdatePacket.writeString(bytes, this.name);
        }
        bytes.writeInt(this.layer);
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        this.value = ByteBufUtils.readTag((ByteBuf)bytes);
        if (bytes.readBoolean()) {
            this.name = ContainerControlUpdatePacket.readString(bytes);
        }
        this.layer = bytes.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerSub) {
            CoreControl control = ((ContainerSub)player.field_71070_bA).layers.get(this.layer);
            if (this.name != null) {
                control = ((SubContainer)control).get(this.name);
            }
            if (control instanceof ContainerControl) {
                ((ContainerControl)control).receivePacket(this.value);
            }
        }
    }

    @Override
    public void executeServer(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerSub) {
            CoreControl control = ((ContainerSub)player.field_71070_bA).layers.get(this.layer);
            if (this.name != null) {
                control = ((SubContainer)control).get(this.name);
            }
            if (control instanceof ContainerControl) {
                ((ContainerControl)control).receivePacket(this.value);
            }
        }
    }
}

