/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks;

import com.google.common.collect.ImmutableList;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.CurbBlock;
import com.silvaniastudios.roads.blocks.NonPaintRoadTopBlock;
import com.silvaniastudios.roads.blocks.RoadBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRoadSnow
extends BlockSnow {
    protected String name;

    public BlockRoadSnow(String name) {
        this.name = name;
        this.func_149663_c("furenikusroads." + name);
        this.setRegistryName(name);
    }

    public void registerItemModel(Item itemBlock) {
        FurenikusRoads.proxy.registerItemRenderer(itemBlock, 0, this.name);
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        DefaultStateMapper b = new DefaultStateMapper();
        BlockStateContainer bsc = this.func_176194_O();
        ImmutableList values = bsc.func_177619_a();
        for (IBlockState state : values) {
            ModelResourceLocation mrl = new ModelResourceLocation(state.func_177230_c().getRegistryName(), b.func_178131_a((Map)state.func_177228_b()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)state.func_177230_c()), (int)this.func_176201_c(state), (ModelResourceLocation)mrl);
        }
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof RoadBlock) {
            IBlockState roadState = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
            RoadBlock block = (RoadBlock)roadState.func_177230_c();
            int meta = block.func_176201_c(roadState);
            return new Vec3d(0.0, -0.9375 + (double)meta * 0.0625, 0.0);
        }
        return super.func_190949_e(state, worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(source, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(source, pos) + 0.0625, 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public double getBlockBelowHeight(IBlockAccess worldIn, BlockPos pos) {
        IBlockState underState = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        Block underBlock = underState.func_177230_c();
        double extraOffset = 0.0;
        if (underBlock instanceof PaintBlockBase || underBlock instanceof NonPaintRoadTopBlock || underBlock instanceof CurbBlock) {
            extraOffset = 0.062;
        }
        return underBlock.func_185496_a((IBlockState)underState, (IBlockAccess)worldIn, (BlockPos)pos.func_177972_a((EnumFacing)EnumFacing.DOWN)).field_72337_e - extraOffset;
    }
}

