/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks;

import com.google.common.base.Predicate;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.BlockFakeLight;
import com.silvaniastudios.roads.blocks.enums.IConnectable;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import com.silvaniastudios.roads.blocks.enums.IPostConnectable;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.items.FRItems;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CurbBlock
extends BlockBase
implements IMetaBlockName {
    public static final PropertyEnum<EnumConnectSidewalk> CONNECT = PropertyEnum.func_177709_a((String)"connect", EnumConnectSidewalk.class);
    public static final PropertyEnum<EnumColourSidewalk> COLOUR = PropertyEnum.func_177709_a((String)"colour", EnumColourSidewalk.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"zz_facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public CurbBlock(String name, Material mat) {
        super(name, mat);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(CONNECT, (Comparable)((Object)EnumConnectSidewalk.NONE)).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.STANDARD)));
        this.func_149647_a(FurenikusRoads.tab_road_parts);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int facingId = 0;
        if (placer.func_174811_aO() == EnumFacing.SOUTH) {
            facingId = 1;
        }
        if (placer.func_174811_aO() == EnumFacing.WEST) {
            facingId = 2;
        }
        if (placer.func_174811_aO() == EnumFacing.EAST) {
            facingId = 3;
        }
        return this.func_176203_a(meta + facingId);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 4));
        items.add((Object)new ItemStack((Block)this, 1, 8));
        items.add((Object)new ItemStack((Block)this, 1, 12));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int rot = 0;
        if (facing == EnumFacing.SOUTH) {
            rot = 1;
        }
        if (facing == EnumFacing.WEST) {
            rot = 2;
        }
        if (facing == EnumFacing.EAST) {
            rot = 3;
        }
        EnumColourSidewalk colour = (EnumColourSidewalk)((Object)state.func_177229_b(COLOUR));
        int col = 0;
        if (colour == EnumColourSidewalk.WHITE) {
            col = 4;
        }
        if (colour == EnumColourSidewalk.YELLOW) {
            col = 8;
        }
        if (colour == EnumColourSidewalk.RED) {
            col = 12;
        }
        return rot + col;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.STANDARD));
        }
        if (meta == 1) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.STANDARD));
        }
        if (meta == 2) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.STANDARD));
        }
        if (meta == 3) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.STANDARD));
        }
        if (meta == 4) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.WHITE));
        }
        if (meta == 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.WHITE));
        }
        if (meta == 6) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.WHITE));
        }
        if (meta == 7) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.WHITE));
        }
        if (meta == 8) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.YELLOW));
        }
        if (meta == 9) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.YELLOW));
        }
        if (meta == 10) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.YELLOW));
        }
        if (meta == 11) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.YELLOW));
        }
        if (meta == 12) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.RED));
        }
        if (meta == 13) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.RED));
        }
        if (meta == 14) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.RED));
        }
        if (meta == 15) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.RED));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(COLOUR, (Comparable)((Object)EnumColourSidewalk.STANDARD));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, CONNECT, COLOUR});
    }

    private EnumConnectSidewalk canLineConnectTo(IBlockAccess world, BlockPos pos, boolean leftSide) {
        int metaOffset;
        IBlockState state = world.func_180495_p(pos);
        int meta = this.func_176201_c(state);
        BlockPos posNorth = pos.func_177972_a(EnumFacing.NORTH);
        BlockPos posEast = pos.func_177972_a(EnumFacing.EAST);
        BlockPos posSouth = pos.func_177972_a(EnumFacing.SOUTH);
        BlockPos posWest = pos.func_177972_a(EnumFacing.WEST);
        boolean blockNorth = world.func_180495_p(posNorth).func_177230_c() instanceof CurbBlock;
        boolean blockEast = world.func_180495_p(posEast).func_177230_c() instanceof CurbBlock;
        boolean blockSouth = world.func_180495_p(posSouth).func_177230_c() instanceof CurbBlock;
        boolean blockWest = world.func_180495_p(posWest).func_177230_c() instanceof CurbBlock;
        boolean blockNorthWest = world.func_180495_p(posNorth.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof CurbBlock;
        boolean blockNorthEast = world.func_180495_p(posNorth.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof CurbBlock;
        boolean blockSouthWest = world.func_180495_p(posSouth.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof CurbBlock;
        boolean blockSouthEast = world.func_180495_p(posSouth.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof CurbBlock;
        if (meta == 0 || meta == 4 || meta == 8 || meta == 12) {
            if (blockSouth) {
                metaOffset = this.func_176201_c(world.func_180495_p(posSouth));
                if (metaOffset == 3 || metaOffset == 7 || metaOffset == 11 || metaOffset == 15) {
                    return EnumConnectSidewalk.RIGHT;
                }
                if (metaOffset == 2 || metaOffset == 6 || metaOffset == 10 || metaOffset == 14) {
                    return EnumConnectSidewalk.LEFT;
                }
            }
            if (blockSouthWest && (metaOffset = this.func_176201_c(world.func_180495_p(posSouth.func_177972_a(EnumFacing.WEST)))) == meta) {
                return EnumConnectSidewalk.LEFT_B;
            }
            if (blockSouthEast && (metaOffset = this.func_176201_c(world.func_180495_p(posSouth.func_177972_a(EnumFacing.EAST)))) == meta) {
                return EnumConnectSidewalk.RIGHT_B;
            }
        }
        if (meta == 3 || meta == 7 || meta == 11 || meta == 15) {
            if (blockWest) {
                metaOffset = this.func_176201_c(world.func_180495_p(posWest));
                if (metaOffset == 0 || metaOffset == 4 || metaOffset == 8 || metaOffset == 12) {
                    return EnumConnectSidewalk.LEFT;
                }
                if (metaOffset == 1 || metaOffset == 5 || metaOffset == 9 || metaOffset == 13) {
                    return EnumConnectSidewalk.RIGHT;
                }
            }
            if (blockNorthWest && (metaOffset = this.func_176201_c(world.func_180495_p(posNorth.func_177972_a(EnumFacing.WEST)))) == meta) {
                return EnumConnectSidewalk.LEFT_B;
            }
            if (blockSouthWest && (metaOffset = this.func_176201_c(world.func_180495_p(posSouth.func_177972_a(EnumFacing.WEST)))) == meta) {
                return EnumConnectSidewalk.RIGHT_B;
            }
        }
        if (meta == 1 || meta == 5 || meta == 9 || meta == 13) {
            if (blockNorth) {
                metaOffset = this.func_176201_c(world.func_180495_p(posNorth));
                if (metaOffset == 3 || metaOffset == 7 || metaOffset == 11 || metaOffset == 15) {
                    return EnumConnectSidewalk.LEFT;
                }
                if (metaOffset == 2 || metaOffset == 6 || metaOffset == 10 || metaOffset == 14) {
                    return EnumConnectSidewalk.RIGHT;
                }
            }
            if (blockNorthEast && (metaOffset = this.func_176201_c(world.func_180495_p(posNorth.func_177972_a(EnumFacing.EAST)))) == meta) {
                return EnumConnectSidewalk.LEFT_B;
            }
            if (blockNorthWest && (metaOffset = this.func_176201_c(world.func_180495_p(posNorth.func_177972_a(EnumFacing.WEST)))) == meta) {
                return EnumConnectSidewalk.RIGHT_B;
            }
        }
        if (meta == 2 || meta == 6 || meta == 10 || meta == 14) {
            if (blockEast) {
                metaOffset = this.func_176201_c(world.func_180495_p(posEast));
                if (metaOffset == 0 || metaOffset == 4 || metaOffset == 8 || metaOffset == 12) {
                    return EnumConnectSidewalk.RIGHT;
                }
                if (metaOffset == 1 || metaOffset == 5 || metaOffset == 9 || metaOffset == 13) {
                    return EnumConnectSidewalk.LEFT;
                }
            }
            if (blockSouthEast && (metaOffset = this.func_176201_c(world.func_180495_p(posSouth.func_177972_a(EnumFacing.EAST)))) == meta) {
                return EnumConnectSidewalk.LEFT_B;
            }
            if (blockNorthEast && (metaOffset = this.func_176201_c(world.func_180495_p(posNorth.func_177972_a(EnumFacing.EAST)))) == meta) {
                return EnumConnectSidewalk.RIGHT_B;
            }
        }
        return EnumConnectSidewalk.NONE;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (item.equals((Object)FRItems.pneumatic_drill) && player.func_70093_af()) {
            world.func_175698_g(pos);
            return true;
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(CONNECT, (Comparable)((Object)this.canLineConnectTo(worldIn, pos, true)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory1"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)4, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory2"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)8, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory3"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)12, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory4"));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0 - this.findBelowBlock(source, pos), 0.0, 1.0, 0.125 - this.findBelowBlock(source, pos), 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() + "";
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof BlockAir && RoadsConfig.general.breakPaintOnBlockBreak) {
            world.func_175698_g(pos);
        }
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        double offsetY = 1.0 - this.getBlockConnectedHeight(state, worldIn, pos);
        return new Vec3d(0.0, -offsetY + 0.75, 0.0);
    }

    private double getBlockConnectedHeight(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos sideOffset;
        IBlockState endBlock;
        int countDown;
        int meta = this.func_176201_c(state);
        EnumFacing checkDir = null;
        if (meta == 0 || meta == 4 || meta == 8 || meta == 12) {
            checkDir = EnumFacing.NORTH;
        }
        if (meta == 3 || meta == 7 || meta == 11 || meta == 15) {
            checkDir = EnumFacing.EAST;
        }
        if (meta == 1 || meta == 5 || meta == 9 || meta == 13) {
            checkDir = EnumFacing.SOUTH;
        }
        if (meta == 2 || meta == 6 || meta == 10 || meta == 14) {
            checkDir = EnumFacing.WEST;
        }
        BlockPos downOffset = pos.func_177972_a(EnumFacing.DOWN);
        IBlockState downState = worldIn.func_180495_p(downOffset);
        for (countDown = 0; (downState.func_177230_c() instanceof PaintBlockBase || downState.func_177230_c() == Blocks.field_150350_a) && countDown < 2; ++countDown) {
            downOffset = downOffset.func_177972_a(EnumFacing.DOWN);
            downState = worldIn.func_180495_p(downOffset);
        }
        if ((downState.func_177230_c() instanceof BlockBase || downState.func_177230_c().func_193383_a(worldIn, downState, downOffset, EnumFacing.UP).equals((Object)BlockFaceShape.SOLID)) && (endBlock = worldIn.func_180495_p(sideOffset = downOffset.func_177972_a(checkDir))).func_177230_c() != Blocks.field_150350_a) {
            IBlockState endState = worldIn.func_180495_p(sideOffset.func_177972_a(EnumFacing.UP));
            System.out.println("endstate: " + endState.func_177230_c().func_149732_F());
            if (endState.func_177230_c() instanceof BlockBase && !(endState.func_177230_c() instanceof PaintBlockBase) && !(endState.func_177230_c() instanceof IConnectable) && !(endState.func_177230_c() instanceof IPostConnectable) && !(endState.func_177230_c() instanceof BlockFakeLight) && endState.func_177230_c().func_149730_j(endState)) {
                return endState.func_185900_c((IBlockAccess)worldIn, (BlockPos)sideOffset.func_177972_a((EnumFacing)EnumFacing.UP)).field_72337_e - (double)countDown;
            }
            return endBlock.func_185900_c((IBlockAccess)worldIn, (BlockPos)sideOffset).field_72337_e - (double)countDown - 1.0;
        }
        return downState.func_185900_c((IBlockAccess)worldIn, (BlockPos)downOffset).field_72337_e - (double)countDown - 1.0;
    }

    private double findBelowBlock(IBlockAccess worldIn, BlockPos pos) {
        int countDown;
        BlockPos downOffset = pos.func_177972_a(EnumFacing.DOWN);
        IBlockState downState = worldIn.func_180495_p(downOffset);
        for (countDown = 0; (downState.func_177230_c() instanceof PaintBlockBase || downState.func_177230_c() == Blocks.field_150350_a) && countDown < 2; ++countDown) {
            downOffset = downOffset.func_177972_a(EnumFacing.DOWN);
            downState = worldIn.func_180495_p(downOffset);
        }
        return 1.0 - downState.func_185900_c((IBlockAccess)worldIn, (BlockPos)downOffset).field_72337_e + (double)countDown + 1.0;
    }

    public static enum EnumColourSidewalk implements IStringSerializable
    {
        STANDARD(0, "standard"),
        WHITE(1, "white"),
        YELLOW(2, "yellow"),
        RED(3, "red");

        private static final EnumColourSidewalk[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumColourSidewalk(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumColourSidewalk byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumColourSidewalk[EnumColourSidewalk.values().length];
            EnumColourSidewalk[] enumColourSidewalkArray = EnumColourSidewalk.values();
            int n = enumColourSidewalkArray.length;
            for (int i = 0; i < n; ++i) {
                EnumColourSidewalk type;
                EnumColourSidewalk.META_LOOKUP[type.getMetadata()] = type = enumColourSidewalkArray[i];
            }
        }
    }

    public static enum EnumConnectSidewalk implements IStringSerializable
    {
        NONE(0, "none"),
        LEFT(1, "left"),
        RIGHT(2, "right"),
        LEFT_B(3, "left_b"),
        RIGHT_B(4, "right_b");

        private static final EnumConnectSidewalk[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumConnectSidewalk(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumConnectSidewalk byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumConnectSidewalk[EnumConnectSidewalk.values().length];
            EnumConnectSidewalk[] enumConnectSidewalkArray = EnumConnectSidewalk.values();
            int n = enumConnectSidewalkArray.length;
            for (int i = 0; i < n; ++i) {
                EnumConnectSidewalk type;
                EnumConnectSidewalk.META_LOOKUP[type.getMetadata()] = type = enumConnectSidewalkArray[i];
            }
        }
    }
}

