/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.BlockRoadSnow;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.items.FRItems;
import com.silvaniastudios.roads.items.RoadItemBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RoadBlock
extends BlockBase {
    public static final PropertyEnum<EnumRoadHeight> ENUM_HEIGHT = PropertyEnum.func_177709_a((String)"road_block", EnumRoadHeight.class);
    public static final AxisAlignedBB ROAD_1_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static final AxisAlignedBB ROAD_2_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final AxisAlignedBB ROAD_3_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    public static final AxisAlignedBB ROAD_4_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public static final AxisAlignedBB ROAD_5_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    public static final AxisAlignedBB ROAD_6_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    public static final AxisAlignedBB ROAD_7_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0);
    public static final AxisAlignedBB ROAD_8_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final AxisAlignedBB ROAD_9_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    public static final AxisAlignedBB ROAD_10_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
    public static final AxisAlignedBB ROAD_11_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0);
    public static final AxisAlignedBB ROAD_12_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    public static final AxisAlignedBB ROAD_13_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);
    public static final AxisAlignedBB ROAD_14_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    public static final AxisAlignedBB ROAD_15_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    public static final AxisAlignedBB ROAD_16_16_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private RoadItemBase fragmentItem;

    public RoadBlock(String name, Material mat, RoadItemBase fragment) {
        super(name, mat);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ENUM_HEIGHT, (Comparable)((Object)EnumRoadHeight.id0)));
        this.func_149647_a(FurenikusRoads.tab_roads);
        this.fragmentItem = fragment;
        this.setHarvestLevel("pneumatic_drill", 0);
        this.func_149711_c(1.0f);
    }

    public RoadItemBase getFragmentItem() {
        return this.fragmentItem;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState stateAbove = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.UP));
        if (stateAbove.func_177230_c() instanceof BlockSnow && !(stateAbove.func_177230_c() instanceof BlockRoadSnow)) {
            if (RoadsConfig.general.snowOnRoads) {
                worldIn.func_180501_a(pos.func_177972_a(EnumFacing.UP), FRBlocks.road_snow.func_176223_P(), 3);
            } else {
                worldIn.func_175698_g(pos.func_177972_a(EnumFacing.UP));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (EnumRoadHeight height : EnumRoadHeight.values()) {
            items.add((Object)new ItemStack((Block)this, 1, height.getMetadata()));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState stateAbove;
        Item item = player.func_184586_b(hand).func_77973_b();
        if (item.equals((Object)FRItems.paint_scraper) && (stateAbove = world.func_180495_p(pos.func_177972_a(EnumFacing.UP))).func_177230_c() instanceof PaintBlockBase) {
            world.func_175698_g(pos.func_177972_a(EnumFacing.UP));
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, this.func_176201_c(state));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ENUM_HEIGHT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ENUM_HEIGHT, (Comparable)((Object)EnumRoadHeight.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumRoadHeight)((Object)state.func_177229_b(ENUM_HEIGHT))).getMetadata();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBoxFromState(state);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getBoxFromState(state);
    }

    public AxisAlignedBB getBoxFromState(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            return ROAD_1_16_AABB;
        }
        if (meta == 1) {
            return ROAD_2_16_AABB;
        }
        if (meta == 2) {
            return ROAD_3_16_AABB;
        }
        if (meta == 3) {
            return ROAD_4_16_AABB;
        }
        if (meta == 4) {
            return ROAD_5_16_AABB;
        }
        if (meta == 5) {
            return ROAD_6_16_AABB;
        }
        if (meta == 6) {
            return ROAD_7_16_AABB;
        }
        if (meta == 7) {
            return ROAD_8_16_AABB;
        }
        if (meta == 8) {
            return ROAD_9_16_AABB;
        }
        if (meta == 9) {
            return ROAD_10_16_AABB;
        }
        if (meta == 10) {
            return ROAD_11_16_AABB;
        }
        if (meta == 11) {
            return ROAD_12_16_AABB;
        }
        if (meta == 12) {
            return ROAD_13_16_AABB;
        }
        if (meta == 13) {
            return ROAD_14_16_AABB;
        }
        if (meta == 14) {
            return ROAD_15_16_AABB;
        }
        if (meta == 15) {
            return ROAD_16_16_AABB;
        }
        return ROAD_12_16_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.checkSideRendering(state, world, pos, face);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.checkSideRendering(state, world, pos, face);
    }

    private boolean checkSideRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(face));
        if (offsetState.func_177230_c() instanceof RoadBlock && offsetState.func_177230_c().func_176201_c(offsetState) >= this.func_176201_c(state)) {
            return false;
        }
        return offsetState.func_193401_d(world, pos.func_177972_a(face), face.func_176734_d()) != BlockFaceShape.SOLID;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (this.func_176201_c(state) < 15 && face != EnumFacing.DOWN && face != EnumFacing.UP) {
            return BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.SOLID;
    }

    public static enum EnumRoadHeight implements IStringSerializable
    {
        id0(0, "1_16th"),
        id1(1, "1_8th"),
        id2(2, "3_16ths"),
        id3(3, "quarter_block"),
        id4(4, "5_16ths"),
        id5(5, "6_16ths"),
        id6(6, "7_16ths"),
        id7(7, "half_block"),
        id8(8, "9_16ths"),
        id9(9, "10_16ths"),
        id10(10, "11_16ths"),
        id11(11, "three_quarter_block"),
        id12(12, "13_16ths"),
        id13(13, "14_16ths"),
        id14(14, "15_16ths"),
        id15(15, "full_block");

        private static final EnumRoadHeight[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumRoadHeight(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumRoadHeight byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumRoadHeight[EnumRoadHeight.values().length];
            EnumRoadHeight[] enumRoadHeightArray = EnumRoadHeight.values();
            int n = enumRoadHeightArray.length;
            for (int i = 0; i < n; ++i) {
                EnumRoadHeight type;
                EnumRoadHeight.META_LOOKUP[type.getMetadata()] = type = enumRoadHeightArray[i];
            }
        }
    }
}

