/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChevronSideLinePaintBlock
extends PaintBlockBase {
    public static final PropertyEnum<EnumTypeRotation> TYPE_ROT = PropertyEnum.func_177709_a((String)"type_rotation", EnumTypeRotation.class);
    public static final PropertyEnum<EnumConnections> CONNECT = PropertyEnum.func_177709_a((String)"connect", EnumConnections.class);

    public ChevronSideLinePaintBlock(String name) {
        super(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.DOWN_N_A)).func_177226_a(CONNECT, (Comparable)((Object)EnumConnections.NONE)));
        this.func_149647_a(FurenikusRoads.tab_paint_junction);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing placerFacing = placer.func_174811_aO();
        int placeMeta = 0;
        IBlockState northBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        IBlockState eastBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        IBlockState southBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        IBlockState westBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        IBlockState upBlock = null;
        IBlockState leftBlock = null;
        IBlockState rightBlock = null;
        IBlockState downBlock = null;
        int leftMeta = -1;
        int rightMeta = -1;
        if (placerFacing.equals((Object)EnumFacing.NORTH)) {
            upBlock = northBlock;
            leftBlock = westBlock;
            rightBlock = eastBlock;
            downBlock = southBlock;
        }
        if (placerFacing.equals((Object)EnumFacing.EAST)) {
            placeMeta = 1;
            upBlock = eastBlock;
            leftBlock = northBlock;
            rightBlock = southBlock;
            downBlock = westBlock;
        }
        if (placerFacing.equals((Object)EnumFacing.SOUTH)) {
            placeMeta = 2;
            upBlock = southBlock;
            leftBlock = eastBlock;
            rightBlock = westBlock;
            downBlock = northBlock;
        }
        if (placerFacing.equals((Object)EnumFacing.WEST)) {
            placeMeta = 3;
            upBlock = westBlock;
            leftBlock = southBlock;
            rightBlock = northBlock;
            downBlock = eastBlock;
        }
        if (leftBlock.func_177230_c() instanceof ChevronSideLinePaintBlock) {
            leftMeta = leftBlock.func_177230_c().func_176201_c(leftBlock);
            if (leftMeta < 4 || leftMeta > 7 && leftMeta < 12) {
                return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.byMetadata(leftMeta + 4)));
            }
            return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.byMetadata(leftMeta - 4)));
        }
        if (rightBlock.func_177230_c() instanceof ChevronSideLinePaintBlock) {
            rightMeta = rightBlock.func_177230_c().func_176201_c(rightBlock);
            if (rightMeta < 4 || rightMeta > 7 && rightMeta < 12) {
                return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.byMetadata(rightMeta + 4)));
            }
            return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.byMetadata(rightMeta - 4)));
        }
        if (upBlock.func_177230_c() instanceof ChevronSideLinePaintBlock) {
            return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.byMetadata(upBlock.func_177230_c().func_176201_c(upBlock))));
        }
        if (downBlock.func_177230_c() instanceof ChevronSideLinePaintBlock) {
            return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.byMetadata(downBlock.func_177230_c().func_176201_c(downBlock))));
        }
        return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.byMetadata(placeMeta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumTypeRotation)((Object)state.func_177229_b(TYPE_ROT))).getIndex();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumTypeRotation.byMetadata(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_ROT, CONNECT});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(CONNECT, (Comparable)((Object)this.connectSide(worldIn, pos)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    private EnumConnections connectSide(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int meta = this.func_176201_c(state);
        boolean blockNorth = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_177230_c() instanceof ChevronSideLinePaintBlock;
        boolean blockEast = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof ChevronSideLinePaintBlock;
        boolean blockSouth = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_177230_c() instanceof ChevronSideLinePaintBlock;
        boolean blockWest = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof ChevronSideLinePaintBlock;
        boolean blockLeft = false;
        boolean blockRight = false;
        if (meta == 0 || meta == 4 || meta == 8 || meta == 12) {
            if (blockEast) {
                blockRight = true;
            }
            if (blockWest) {
                blockLeft = true;
            }
        }
        if (meta == 1 || meta == 5 || meta == 9 || meta == 13) {
            if (blockSouth) {
                blockRight = true;
            }
            if (blockNorth) {
                blockLeft = true;
            }
        }
        if (meta == 2 || meta == 6 || meta == 10 || meta == 14) {
            if (blockWest) {
                blockRight = true;
            }
            if (blockEast) {
                blockLeft = true;
            }
        }
        if (meta == 3 || meta == 7 || meta == 11 || meta == 15) {
            if (blockNorth) {
                blockRight = true;
            }
            if (blockSouth) {
                blockLeft = true;
            }
        }
        if (!blockLeft && blockRight) {
            return EnumConnections.LINE_LEFT;
        }
        if (blockLeft && !blockRight) {
            return EnumConnections.LINE_RIGHT;
        }
        if (!blockLeft && !blockRight) {
            return EnumConnections.LINE_BOTH;
        }
        return EnumConnections.NONE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public static enum EnumTypeRotation implements IStringSerializable
    {
        DOWN_N_A(0, "down_n_a"),
        DOWN_E_A(1, "down_e_a"),
        DOWN_S_A(2, "down_s_a"),
        DOWN_W_A(3, "down_w_a"),
        DOWN_N_B(4, "down_n_b"),
        DOWN_E_B(5, "down_e_b"),
        DOWN_S_B(6, "down_s_b"),
        DOWN_W_B(7, "down_w_b"),
        UP_N_A(8, "up_n_a"),
        UP_E_A(9, "up_e_a"),
        UP_S_A(10, "up_s_a"),
        UP_W_A(11, "up_w_a"),
        UP_N_B(12, "up_n_b"),
        UP_E_B(13, "up_e_b"),
        UP_S_B(14, "up_s_b"),
        UP_W_B(15, "up_w_b");

        private static final EnumTypeRotation[] INDEX_LOOKUP;
        private final int index;
        private final String name;

        private EnumTypeRotation(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumTypeRotation byMetadata(int meta) {
            if (meta < 0 || meta >= INDEX_LOOKUP.length) {
                meta = 0;
            }
            return INDEX_LOOKUP[meta];
        }

        static {
            INDEX_LOOKUP = new EnumTypeRotation[EnumTypeRotation.values().length];
            EnumTypeRotation[] enumTypeRotationArray = EnumTypeRotation.values();
            int n = enumTypeRotationArray.length;
            for (int i = 0; i < n; ++i) {
                EnumTypeRotation type;
                EnumTypeRotation.INDEX_LOOKUP[type.getIndex()] = type = enumTypeRotationArray[i];
            }
        }
    }

    public static enum EnumConnections implements IStringSerializable
    {
        NONE(0, "none"),
        LINE_LEFT(1, "line_left"),
        LINE_RIGHT(2, "line_right"),
        LINE_BOTH(3, "line_both");

        private static final EnumConnections[] ID_LOOKUP;
        private final int id;
        private final String name;

        private EnumConnections(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static EnumConnections byId(int id) {
            if (id < 0 || id >= ID_LOOKUP.length) {
                id = 0;
            }
            return ID_LOOKUP[id];
        }

        static {
            ID_LOOKUP = new EnumConnections[EnumConnections.values().length];
            EnumConnections[] enumConnectionsArray = EnumConnections.values();
            int n = enumConnectionsArray.length;
            for (int i = 0; i < n; ++i) {
                EnumConnections type;
                EnumConnections.ID_LOOKUP[type.getId()] = type = enumConnectionsArray[i];
            }
        }
    }
}

