/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.tarmaccutter;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.RoadBlock;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterContainer;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterStackHandler;
import com.silvaniastudios.roads.items.FRItems;
import com.silvaniastudios.roads.items.TarmacCutterBlade;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TarmacCutterEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    public int timerCount = 0;
    public ItemStackHandler inventory = new ItemStackHandler(5){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        protected void onContentsChanged(int slot) {
            TarmacCutterEntity.this.func_70296_d();
        }
    };
    public TarmacCutterStackHandler interactable_inv = new TarmacCutterStackHandler(this.inventory, this.hasCapability(CapabilityEnergy.ENERGY, null));

    public Container createContainer(EntityPlayer player) {
        return new TarmacCutterContainer(player.field_71071_by, this, false);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.interactable_inv);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.fuel_remaining > 0) {
            --this.fuel_remaining;
        } else if (this.fuel_remaining <= 0) {
            if (!this.inventory.getStackInSlot(4).func_190926_b()) {
                this.last_fuel_cap = this.fuel_remaining = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(4));
                if (this.inventory.getStackInSlot(4).func_77973_b() == Items.field_151129_at) {
                    this.inventory.setStackInSlot(4, new ItemStack(Items.field_151133_ar));
                } else {
                    this.inventory.extractItem(4, 1, false);
                }
                this.sendUpdates();
            } else {
                this.timerCount = 0;
                return;
            }
        }
        if (this.timerCount < RoadsConfig.machine.tarmacCutterTickRate) {
            this.timerCount = this.shouldTick() ? ++this.timerCount : 0;
        } else {
            this.process();
            this.timerCount = 0;
        }
    }

    public void process() {
        FurenikusRoads.debug(2, "Tarmac Cutter at" + this.formatPosition(this.field_174879_c) + "processing");
        if (!this.field_145850_b.field_72995_K) {
            ItemStack in = this.inventory.getStackInSlot(0);
            ItemStack blade = this.inventory.getStackInSlot(1);
            ItemStack blockOut = this.inventory.getStackInSlot(2);
            ItemStack fragOut = this.inventory.getStackInSlot(3);
            if (blade.func_77973_b() instanceof TarmacCutterBlade) {
                if (blade.func_77952_i() < blade.func_77958_k()) {
                    ItemBlock ib;
                    int cutSize = this.getCutSize(blade);
                    if (in.func_77952_i() >= cutSize && in.func_77973_b() instanceof ItemBlock && (ib = (ItemBlock)in.func_77973_b()).func_179223_d() instanceof RoadBlock) {
                        RoadBlock block = (RoadBlock)ib.func_179223_d();
                        if ((blockOut.func_190926_b() || blockOut.func_77973_b() == in.func_77973_b() && blockOut.func_77952_i() == in.func_77952_i() - cutSize) && (fragOut.func_190926_b() || fragOut.func_77973_b() == block.getFragmentItem() && fragOut.func_190916_E() <= fragOut.func_77976_d() - cutSize)) {
                            in.func_190920_e(in.func_190916_E() - 1);
                            if (blockOut.func_190926_b()) {
                                this.inventory.setStackInSlot(2, new ItemStack(in.func_77973_b(), 1, in.func_77952_i() - cutSize));
                            } else {
                                blockOut.func_190920_e(blockOut.func_190916_E() + 1);
                            }
                            if (fragOut.func_190926_b()) {
                                ItemStack fragment = new ItemStack((Item)block.getFragmentItem(), cutSize);
                                this.inventory.setStackInSlot(3, fragment);
                            } else {
                                fragOut.func_190920_e(fragOut.func_190916_E() + cutSize);
                            }
                            blade.func_77964_b(blade.func_77952_i() + 1);
                            this.sendUpdates();
                        }
                    }
                } else {
                    this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                }
            }
        }
    }

    public boolean shouldTick() {
        ItemStack in = this.inventory.getStackInSlot(0);
        ItemStack blade = this.inventory.getStackInSlot(1);
        ItemStack blockOut = this.inventory.getStackInSlot(2);
        ItemStack fragOut = this.inventory.getStackInSlot(3);
        if (blade.func_77973_b() instanceof TarmacCutterBlade && blade.func_77952_i() < blade.func_77958_k()) {
            ItemBlock ib;
            int cutSize = this.getCutSize(blade);
            if (in.func_77952_i() >= cutSize && in.func_77973_b() instanceof ItemBlock && (ib = (ItemBlock)in.func_77973_b()).func_179223_d() instanceof RoadBlock) {
                RoadBlock block = (RoadBlock)ib.func_179223_d();
                if ((blockOut.func_190926_b() || blockOut.func_77973_b() == in.func_77973_b() && blockOut.func_77952_i() == in.func_77952_i() - cutSize && blockOut.func_190916_E() <= blockOut.func_77976_d() + in.func_190916_E()) && (fragOut.func_190926_b() || fragOut.func_77973_b() == block.getFragmentItem() && fragOut.func_190916_E() <= fragOut.func_77976_d() - cutSize)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int getCutSize(ItemStack stack) {
        if (stack.func_77973_b() instanceof TarmacCutterBlade) {
            TarmacCutterBlade blade = (TarmacCutterBlade)stack.func_77973_b();
            return blade.size;
        }
        if (stack.func_77973_b() == FRItems.tarmac_cutter_blade_1_iron || stack.func_77973_b() == FRItems.tarmac_cutter_blade_1_gold || stack.func_77973_b() == FRItems.tarmac_cutter_blade_1_diamond) {
            return 1;
        }
        if (stack.func_77973_b() == FRItems.tarmac_cutter_blade_2_iron || stack.func_77973_b() == FRItems.tarmac_cutter_blade_2_gold || stack.func_77973_b() == FRItems.tarmac_cutter_blade_2_diamond) {
            return 2;
        }
        if (stack.func_77973_b() == FRItems.tarmac_cutter_blade_4_iron || stack.func_77973_b() == FRItems.tarmac_cutter_blade_4_gold || stack.func_77973_b() == FRItems.tarmac_cutter_blade_4_diamond) {
            return 4;
        }
        if (stack.func_77973_b() == FRItems.tarmac_cutter_blade_8_iron || stack.func_77973_b() == FRItems.tarmac_cutter_blade_8_gold || stack.func_77973_b() == FRItems.tarmac_cutter_blade_8_diamond) {
            return 8;
        }
        return 0;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        this.fuel_remaining = nbt.func_74762_e("fuel");
        this.last_fuel_cap = nbt.func_74762_e("fuel_last_used");
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74768_a("fuel", this.fuel_remaining);
        nbt.func_74768_a("fuel_last_used", this.last_fuel_cap);
        return nbt;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return this.writeNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
    }
}

