/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.gui;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerContainer;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerEntity;
import com.silvaniastudios.roads.items.FRItems;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidTank;

public class GuiTarDistiller
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("furenikusroads:textures/gui/tar_distiller.png");
    private TarDistillerEntity tileEntity;
    private boolean electric;

    public GuiTarDistiller(TarDistillerEntity tileEntity, TarDistillerContainer container, boolean electric) {
        super((Container)container);
        this.field_146999_f = 196;
        this.field_147000_g = 208;
        this.tileEntity = tileEntity;
        this.electric = electric;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.drawTooltip(2, left, top, mouseX, mouseY);
        if (this.electric) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.electric_tar_distiller.name", (Object[])new Object[0]), 32, 6, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"roads.gui.tar_distiller.name", (Object[])new Object[0]), 32, 6, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(left + 176, top + 62, 176, 62, 20, 54);
        if (this.electric) {
            this.func_73729_b(left + this.field_146999_f - 23, top, 196, 0, 23, 116);
        }
        this.drawFluid(left + 8, top + 8, this.tileEntity.fluidInput);
        this.drawFluid(left + 122, top + 8, this.tileEntity.fluidOutput1);
        this.drawFluid(left + 148, top + 8, this.tileEntity.fluidOutput2);
        this.drawFuel(left, top);
        this.drawProgress(left, top);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void drawFuel(int left, int top) {
        if (this.electric) {
            TarDistillerElectricEntity tdee = (TarDistillerElectricEntity)this.tileEntity;
            int p = this.getPercentage(tdee.energy.getEnergyStored(), tdee.energy.getMaxEnergyStored());
            int x = Math.round((float)p / 2.5f);
            if (p == 100) {
                x = 42;
            }
            this.func_73729_b(left + 175, top + 7 + (42 - x), 242, 42 - x, 14, x);
        } else {
            int p = this.getPercentage(this.tileEntity.fuel_remaining, this.tileEntity.last_fuel_cap);
            int x = Math.round((float)p / 7.0f);
            this.func_73729_b(left + 175, top + 11 + (14 - x), 228, 14 - x, 14, x);
        }
    }

    private void drawProgress(int left, int top) {
        int p = this.getPercentage(this.tileEntity.timerCount, RoadsConfig.machine.tarDistillerTickRate);
        int x = Math.round((float)p * 1.6f);
        this.func_73729_b(left + 8, top + 116, 0, 252, x, 4);
    }

    private void drawTooltip(int col, int left, int top, int mouseX, int mouseY) {
        if (mouseX >= left + 8 && mouseX <= left + 28 && mouseY >= top + 8 && mouseY <= top + 108) {
            this.func_146279_a(this.tileEntity.fluidInput.getFluidAmount() + "/" + 320000, mouseX - left, mouseY - top + 15);
        }
        if (mouseX >= left + 122 && mouseX <= left + 142 && mouseY >= top + 8 && mouseY <= top + 108) {
            this.func_146279_a(this.tileEntity.fluidOutput1.getFluidAmount() + "/" + 320000, mouseX - left, mouseY - top + 15);
        }
        if (mouseX >= left + 148 && mouseX <= left + 168 && mouseY >= top + 8 && mouseY <= top + 108) {
            this.func_146279_a(this.tileEntity.fluidOutput2.getFluidAmount() + "/" + 320000, mouseX - left, mouseY - top + 15);
        }
        if (this.electric) {
            TarDistillerElectricEntity tdee = (TarDistillerElectricEntity)this.tileEntity;
            if (mouseX >= left + 175 && mouseX <= left + 189 && mouseY >= top + 7 && mouseY <= top + 49) {
                this.func_146279_a(tdee.energy.getEnergyStored() + "/" + tdee.energy.getMaxEnergyStored(), mouseX - left, mouseY - top + 15);
            }
        } else if (mouseX >= left + 175 && mouseX <= left + 189 && mouseY >= top + 11 && mouseY <= top + 25) {
            this.func_146279_a(this.tileEntity.fuel_remaining + "/" + this.tileEntity.last_fuel_cap, mouseX - left, mouseY - top + 15);
        }
        if (RoadsConfig.general.guiGuide) {
            String a = TextFormatting.RESET + " -> " + TextFormatting.GREEN;
            List<String> inputList = Arrays.asList(I18n.func_135052_a((String)"roads.gui.inputSlot", (Object[])new Object[0]), "", TextFormatting.UNDERLINE + I18n.func_135052_a((String)"roads.gui.valid", (Object[])new Object[0]), TextFormatting.AQUA + new ItemStack(Items.field_151044_h, 1, 0).func_82833_r() + a + new ItemStack((Item)FRItems.coal_coke, 1, 0).func_82833_r());
            if (mouseX >= left + 34 && mouseX <= left + 50 && mouseY >= top + 30 && mouseY <= top + 46 && this.tileEntity.inventory.getStackInSlot(0).func_190916_E() == 0) {
                this.func_146283_a(inputList, mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 34 && mouseX <= left + 50 && mouseY >= top + 70 && mouseY <= top + 86 && this.tileEntity.inventory.getStackInSlot(4).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fluidInputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 34 && mouseX <= left + 50 && mouseY >= top + 92 && mouseY <= top + 108 && this.tileEntity.inventory.getStackInSlot(7).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.bucketOutputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 174 && mouseX <= left + 190 && mouseY >= top + 30 && mouseY <= top + 46 && !this.electric && this.tileEntity.inventory.getStackInSlot(3).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fuelSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 100 && mouseX <= left + 116 && mouseY >= top + 70 && mouseY <= top + 86 && this.tileEntity.inventory.getStackInSlot(5).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.bucketInputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 100 && mouseX <= left + 116 && mouseY >= top + 92 && mouseY <= top + 108 && this.tileEntity.inventory.getStackInSlot(8).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fluidOutputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 174 && mouseX <= left + 190 && mouseY >= top + 70 && mouseY <= top + 86 && this.tileEntity.inventory.getStackInSlot(6).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.bucketInputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 174 && mouseX <= left + 190 && mouseY >= top + 92 && mouseY <= top + 108 && this.tileEntity.inventory.getStackInSlot(9).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.fluidOutputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 100 && mouseX <= left + 116 && mouseY >= top + 8 && mouseY <= top + 24 && this.tileEntity.inventory.getStackInSlot(1).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.outputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
            if (mouseX >= left + 100 && mouseX <= left + 116 && mouseY >= top + 30 && mouseY <= top + 46 && this.tileEntity.inventory.getStackInSlot(2).func_190916_E() == 0) {
                this.func_146279_a(I18n.func_135052_a((String)"roads.gui.outputSlot", (Object[])new Object[0]), mouseX - left, mouseY - top + 15);
            }
        }
    }

    private void drawFluid(int left, int top, FluidTank fluid) {
        if (fluid.getFluidAmount() > 0) {
            int fillPercent = this.getPercentage(fluid.getFluidAmount(), 320000);
            this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getFluid().getStill(fluid.getFluid()).toString());
            for (int i = 0; i < 6; ++i) {
                this.drawFluidQuad(left, top + i * 16, 16, 16, texture);
                this.drawFluidQuad(left + 16, top + i * 16, 4, 16, texture);
            }
            this.drawFluidQuad(left, top + 96, 16, 4, texture);
            this.drawFluidQuad(left + 16, top + 96, 4, 4, texture);
            this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
            this.func_73729_b(left, top, 8, 8, 20, 100 - fillPercent);
        }
        this.func_73729_b(left, top, 236, 156, 20, 100);
    }

    private void drawFluidQuad(int x, int y, int width, int height, TextureAtlasSprite texture) {
        float minU = texture.func_94214_a(0.0);
        float minV = texture.func_94207_b(0.0);
        float maxU = texture.func_94214_a((double)width);
        float maxV = texture.func_94207_b((double)height);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)minU, (double)maxV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)maxU, (double)minV).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
    }

    private int getPercentage(int num, int max) {
        float x = (float)num / (float)max;
        int y = Math.round(x * 100.0f);
        if (y > 100) {
            return 100;
        }
        if (y == 0 && num > 0) {
            return 1;
        }
        return y;
    }
}

