/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.items;

import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PaintGunItemRegistry {
    public static ArrayList<PaintBlockBase> lines = new ArrayList();
    public static ArrayList<PaintBlockBase> icons = new ArrayList();
    public static ArrayList<PaintBlockBase> letters = new ArrayList();
    public static ArrayList<PaintBlockBase> text = new ArrayList();
    public static ArrayList<PaintBlockBase> junction = new ArrayList();
    public static ArrayList<PaintBlockBase> other = new ArrayList();
    public static ArrayList<Integer> linesMeta = new ArrayList();
    public static ArrayList<Integer> iconsMeta = new ArrayList();
    public static ArrayList<Integer> lettersMeta = new ArrayList();
    public static ArrayList<Integer> textMeta = new ArrayList();
    public static ArrayList<Integer> junctionMeta = new ArrayList();
    public static ArrayList<Integer> otherMeta = new ArrayList();

    public static void registerLine(PaintBlockBase block) {
        lines.add(block);
        linesMeta.add(0);
    }

    public static void registerLine(PaintBlockBase block, int meta) {
        lines.add(block);
        linesMeta.add(meta);
    }

    public static void registerIcons(PaintBlockBase block) {
        icons.add(block);
        iconsMeta.add(0);
    }

    public static void registerIcons(PaintBlockBase block, int meta) {
        icons.add(block);
        iconsMeta.add(meta);
    }

    public static void registerLetters(PaintBlockBase block) {
        letters.add(block);
        lettersMeta.add(0);
        letters.add(block);
        lettersMeta.add(8);
    }

    public static void registerText(PaintBlockBase block) {
        text.add(block);
        textMeta.add(0);
    }

    public static void registerText(PaintBlockBase block, int meta) {
        text.add(block);
        textMeta.add(meta);
    }

    public static void registerJunction(PaintBlockBase block) {
        junction.add(block);
        junctionMeta.add(0);
    }

    public static void registerJunction(PaintBlockBase block, int meta) {
        junction.add(block);
        junctionMeta.add(meta);
    }

    public static void registerOther(PaintBlockBase block) {
        other.add(block);
        otherMeta.add(0);
    }

    public static void registerOther(PaintBlockBase block, int meta) {
        other.add(block);
        otherMeta.add(meta);
    }

    public static PaintBlockBase getBlockFromIdAndPage(int id, int page) {
        if (id >= 0) {
            if (page == 1 && id < lines.size()) {
                return lines.get(id);
            }
            if (page == 2 && id < icons.size()) {
                return icons.get(id);
            }
            if (page == 3 && id < letters.size()) {
                return letters.get(id);
            }
            if (page == 4 && id < text.size() / 2) {
                return text.get(id);
            }
            if (page == 5 && id < junction.size()) {
                return junction.get(id);
            }
        }
        return null;
    }

    public static PaintBlockBase getWhite(PaintBlockBase block) {
        PaintBlockBase newBlock;
        String unloc = block.func_149739_a().substring(20);
        if (unloc.contains("yellow")) {
            unloc = unloc.replaceAll("yellow", "white");
        }
        if (unloc.contains("red")) {
            unloc = unloc.replaceAll("red", "white");
        }
        if ((newBlock = (PaintBlockBase)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("furenikusroads", unloc))) != null) {
            return newBlock;
        }
        return block;
    }

    public static PaintBlockBase getYellow(PaintBlockBase block) {
        PaintBlockBase newBlock;
        String unloc = block.func_149739_a().substring(20);
        if (unloc.contains("white")) {
            unloc = unloc.replaceAll("white", "yellow");
        }
        if (unloc.contains("red")) {
            unloc = unloc.replaceAll("red", "yellow");
        }
        if ((newBlock = (PaintBlockBase)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("furenikusroads", unloc))) != null) {
            return newBlock;
        }
        return block;
    }

    public static PaintBlockBase getRed(PaintBlockBase block) {
        PaintBlockBase newBlock;
        String unloc = block.func_149739_a().substring(20);
        if (unloc.contains("white")) {
            unloc = unloc.replaceAll("white", "red");
        }
        if (unloc.contains("yellow")) {
            unloc = unloc.replaceAll("yellow", "red");
        }
        if ((newBlock = (PaintBlockBase)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("furenikusroads", unloc))) != null) {
            return newBlock;
        }
        return block;
    }

    public static int findLineId(PaintBlockBase block, int meta) {
        for (int i = 0; i < lines.size(); ++i) {
            if (!((Object)((Object)lines.get(i))).equals((Object)block)) continue;
            int count = 0;
            while (i + count < lines.size() && ((Object)((Object)lines.get(i + count))).equals((Object)block)) {
                ++count;
            }
            for (int j = 0; j < count; ++j) {
                if (linesMeta.get(i + j) <= meta) continue;
                return i + j - 1;
            }
            return i;
        }
        return -1;
    }

    public static int findIconId(PaintBlockBase block, int meta) {
        for (int i = 0; i < icons.size(); ++i) {
            if (!((Object)((Object)icons.get(i))).equals((Object)block)) continue;
            int count = 0;
            while (i + count < icons.size() && ((Object)((Object)icons.get(i + count))).equals((Object)block)) {
                ++count;
            }
            for (int j = 0; j < count; ++j) {
                if (iconsMeta.get(i + j) <= meta) continue;
                return i + j - 1;
            }
            return i;
        }
        return -1;
    }

    public static int findLetterId(PaintBlockBase block, int meta) {
        for (int i = 0; i < letters.size(); ++i) {
            if (!((Object)((Object)letters.get(i))).equals((Object)block)) continue;
            int count = 0;
            while (i + count < letters.size() && ((Object)((Object)letters.get(i + count))).equals((Object)block)) {
                ++count;
            }
            for (int j = 0; j < count; ++j) {
                if (lettersMeta.get(i + j) <= meta) continue;
                return i + j - 1;
            }
            return i;
        }
        return -1;
    }

    public static int findTextId(PaintBlockBase block, int meta) {
        for (int i = 0; i < text.size(); ++i) {
            if (!((Object)((Object)text.get(i))).equals((Object)block)) continue;
            int count = 0;
            while (i + count < text.size() && ((Object)((Object)text.get(i + count))).equals((Object)block)) {
                ++count;
            }
            for (int j = 0; j < count; ++j) {
                if (textMeta.get(i + j) <= meta) continue;
                return i + j - 1;
            }
            return i;
        }
        return -1;
    }

    public static int findJunctionId(PaintBlockBase block, int meta) {
        for (int i = 0; i < junction.size(); ++i) {
            if (!((Object)((Object)junction.get(i))).equals((Object)block)) continue;
            int count = 0;
            while (i + count < junction.size() && ((Object)((Object)junction.get(i + count))).equals((Object)block)) {
                ++count;
            }
            for (int j = 0; j < count; ++j) {
                if (junctionMeta.get(i + j) <= meta) continue;
                return i + j - 1;
            }
            return i;
        }
        return -1;
    }
}

