/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.jei;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.jei.CrusherWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CrusherCategory
implements IRecipeCategory<CrusherWrapper> {
    private final IDrawable background;
    private final IDrawable electric_bar;
    private final IDrawable icon;
    private final IDrawableAnimated progressBar;
    public static final int width = 162;
    public static final int height = 52;
    private boolean electric = false;
    private String uid;

    public CrusherCategory(IGuiHelper guiHelper, String uid, boolean electric) {
        ResourceLocation guiTexture = new ResourceLocation("furenikusroads:textures/gui/jei_texture_1.png");
        this.background = guiHelper.createDrawable(guiTexture, 0, 0, 162, 52);
        this.electric_bar = guiHelper.createDrawable(guiTexture, 164, 0, 18, 52);
        this.icon = electric ? guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.crusher_electric)) : guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.crusher));
        int progressTick = electric ? RoadsConfig.machine.electricCrusherTickRate : RoadsConfig.machine.crusherTickRate;
        this.progressBar = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(guiTexture, 0, 252, 160, 4), progressTick, IDrawableAnimated.StartDirection.LEFT, false);
        this.electric = electric;
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        if (this.electric) {
            return I18n.func_135052_a((String)"roads.gui.electric_crusher.name", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"roads.gui.crusher.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Fureniku's Roads";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.electric) {
            this.electric_bar.draw(minecraft, 144, 0);
        }
        this.progressBar.draw(minecraft, 1, 47);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrusherWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiStack = recipeLayout.getItemStacks();
        guiStack.init(0, true, 0, 24);
        guiStack.init(1, false, 90, 24);
        guiStack.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        guiStack.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

