/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade;

import net.minecraftforge.common.config.Config;

@Config(modid="tolaserblade", category="")
public class ToLaserBladeConfig {
    @Config.Comment(value={"Common settings. If you are playing a multiplayer game, the server-side settings will be used."})
    @Config.LangKey(value="tolaserblade.configgui.category.commonConfig")
    public static CommonConfig common = new CommonConfig();
    @Config.Comment(value={"Client-side settings."})
    @Config.LangKey(value="tolaserblade.configgui.category.clientConfig")
    public static ClientConfig client = new ClientConfig();
    @Config.Ignore
    public static ServerConfig server = new ServerConfig();

    public static void init() {
        ToLaserBladeConfig.server.isEnabledBlockingWithLaserBlade = ToLaserBladeConfig.common.isEnabledBlockingWithLaserBlade;
        ToLaserBladeConfig.server.laserBladeEfficiency = ToLaserBladeConfig.common.laserBladeEfficiency;
    }

    public static class ServerConfig {
        @Config.Ignore
        public boolean isEnabledBlockingWithLaserBlade;
        @Config.Ignore
        public int laserBladeEfficiency;
    }

    public static class ClientConfig {
        @Config.Comment(value={"Enable Laser Blade to use 3D Model."})
        @Config.LangKey(value="tolaserblade.configgui.enableLaserBlade3DModel")
        @Config.Name(value="enableLaserBlade3DModel")
        public boolean isEnabledLaserBlade3DModel = true;
        @Config.Comment(value={"Select rendering mode of Laser Blade (0: Default, 1: Using only alpha blending). This option is available when enableLaserBlade3DModel is true."})
        @Config.LangKey(value="tolaserblade.configgui.laserBladeRenderingMode")
        @Config.RangeInt(min=0, max=1)
        @Config.Name(value="laserBladeRenderingMode")
        public int laserBladeRenderingMode = 0;
    }

    public static class CommonConfig {
        @Config.Comment(value={"Enable blocking with Laser Blade."})
        @Config.LangKey(value="tolaserblade.configgui.enableBlockingWithLaserBlade")
        @Config.Name(value="enableBlockingWithLaserBlade")
        public boolean isEnabledBlockingWithLaserBlade = false;
        @Config.Comment(value={"An integer value that is a factor of mining speed of Laser Blade."})
        @Config.LangKey(value="tolaserblade.configgui.laserBladeEfficiency")
        @Config.RangeInt(min=0, max=128)
        @Config.Name(value="laserBladeEfficiency")
        public int laserBladeEfficiency = 12;
        @Config.Comment(value={"Enable to attack with Laser Blade in Dispenser when the dispenser is activated."})
        @Config.LangKey(value="tolaserblade.configgui.enableLaserTrap")
        @Config.Name(value="enableLaserTrap")
        public boolean isEnabledLaserTrap = true;
        @Config.Comment(value={"A boolean value represents whether laser trap can attack player or not."})
        @Config.LangKey(value="tolaserblade.configgui.canLaserTrapAttackPlayer")
        @Config.Name(value="canLaserTrapAttackPlayer")
        public boolean canLaserTrapAttackPlayer = false;
    }
}

