/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ModelLaserBlade
implements IBakedModel {
    public final IBakedModel bakedJSONModel;
    public ItemStack itemStack;
    public World world;
    public EntityLivingBase entity;
    public ItemCameraTransforms.TransformType cameraTransformType = ItemCameraTransforms.TransformType.NONE;
    public IBlockState state;
    public EnumFacing side;
    public long rand;
    public int renderingMode = 0;
    public final Map<String, List<BakedQuad>> mapQuads_0 = new HashMap<String, List<BakedQuad>>();
    public final Map<String, List<BakedQuad>> mapQuads_1 = new HashMap<String, List<BakedQuad>>();
    public final String[] partNames = new String[]{"Hilt", "Hilt_bright", "Blade_core", "Blade_halo_1", "Blade_halo_2"};

    public ModelLaserBlade(IBakedModel bakedOBJModelIn, IBakedModel bakedJSONModelIn) {
        this(bakedOBJModelIn, bakedJSONModelIn, false);
    }

    public ModelLaserBlade(IBakedModel bakedOBJModelIn, IBakedModel bakedOBJModelSubIn, IBakedModel bakedJSONModelIn) {
        this(bakedOBJModelIn, bakedOBJModelSubIn, bakedJSONModelIn, false);
    }

    public ModelLaserBlade(IBakedModel bakedOBJModelIn, IBakedModel bakedJSONModelIn, boolean isInitialized) {
        this.bakedJSONModel = bakedJSONModelIn;
        if (!isInitialized) {
            for (String partName : this.partNames) {
                this.mapQuads_0.put(partName, this.getPartQuads(bakedOBJModelIn, (List<String>)ImmutableList.of((Object)partName)));
                this.mapQuads_1.putAll(this.mapQuads_0);
            }
        }
    }

    public ModelLaserBlade(IBakedModel bakedOBJModelIn, IBakedModel bakedOBJModelSubIn, IBakedModel bakedJSONModelIn, boolean isInitialized) {
        this.bakedJSONModel = bakedJSONModelIn;
        if (!isInitialized) {
            for (String partName : this.partNames) {
                this.mapQuads_0.put(partName, this.getPartQuads(bakedOBJModelIn, (List<String>)ImmutableList.of((Object)partName)));
                this.mapQuads_1.put(partName, this.getPartQuads(bakedOBJModelSubIn, (List<String>)ImmutableList.of((Object)partName)));
            }
        }
    }

    public List<BakedQuad> getPartQuads(IBakedModel bakedModelIn, List<String> visibleGroups) {
        List quads = Collections.EMPTY_LIST;
        if (bakedModelIn instanceof OBJModel.OBJBakedModel) {
            try {
                OBJModel obj = ((OBJModel.OBJBakedModel)bakedModelIn).getModel();
                IModelState modelState = part -> {
                    UnmodifiableIterator parts;
                    if (part.isPresent() && (parts = Models.getParts((IModelPart)((IModelPart)part.get()))).hasNext()) {
                        String name = (String)parts.next();
                        if (!parts.hasNext() && visibleGroups.contains(name)) {
                            return Optional.empty();
                        }
                        return Optional.of(TRSRTransformation.identity());
                    }
                    return Optional.empty();
                };
                IBakedModel bakedModel = obj.bake(modelState, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                quads = bakedModel.func_188616_a(null, null, 0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return quads;
    }

    public void handleItemState(ItemStack itemStackIn, World worldIn, EntityLivingBase entityLivingBaseIn) {
        this.itemStack = itemStackIn;
        this.world = worldIn;
        this.entity = entityLivingBaseIn;
    }

    public List<BakedQuad> func_188616_a(IBlockState blockStateIn, EnumFacing enumFacingIn, long longRand) {
        if (enumFacingIn == null) {
            this.state = blockStateIn;
            this.side = enumFacingIn;
            this.rand = longRand;
            if (longRand >= 0L && longRand < (long)this.partNames.length) {
                return this.mapQuads_0.get(this.partNames[(int)longRand]);
            }
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getQuadsByName(String name) {
        Map<String, List<BakedQuad>> mapQuads = this.renderingMode == 1 ? this.mapQuads_1 : this.mapQuads_0;
        if (mapQuads.containsKey(name)) {
            return mapQuads.get(name);
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedJSONModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedJSONModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Collections.EMPTY_LIST){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                if (originalModel instanceof ModelLaserBlade) {
                    ModelLaserBlade model = (ModelLaserBlade)originalModel;
                    model.handleItemState(stack, world, entity);
                    return model;
                }
                return originalModel;
            }
        };
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transformTypeIn) {
        Matrix4f matrix = (Matrix4f)this.bakedJSONModel.handlePerspective(transformTypeIn).getValue();
        this.cameraTransformType = transformTypeIn;
        if (ToLaserBladeConfig.client.isEnabledLaserBlade3DModel) {
            return Pair.of((Object)this, (Object)matrix);
        }
        return Pair.of((Object)this.bakedJSONModel, (Object)matrix);
    }
}

