/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.item;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.item.DispenseLaserBladeBehavior;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomeVoid;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ItemLaserBlade
extends ItemSword {
    private final Item.ToolMaterial material;
    private final float attackDamage;
    private final float attackSpeed;
    public static final int[] colors = new int[]{-65536, -3104768, -16719872, -16744193, -16776961, -6291201, -1, -16645630, -6291328};
    public static final int[] dyeColors = new int[]{-1, -38881, -65408, -16733441, -4608, -5636302, -65460, -11184811, -5592406, -16711681, -65281, -16776961, -38144, -8323328, -65536, -16645630};
    public static final String KEY_ATK = "ATK";
    public static final String KEY_SPD = "SPD";
    public static final String KEY_COLOR_GRIP = "colorG";
    public static final String KEY_COLOR_CORE = "colorC";
    public static final String KEY_COLOR_HALO = "colorH";
    public static final String KEY_IS_SUB_COLOR_CORE = "isSubC";
    public static final String KEY_IS_SUB_COLOR_HALO = "isSubH";
    public static final String KEY_IS_CRAFTING = "isCrafting";
    public static final float MOD_SPD_CLASS_3 = 1.2f;
    public static final float MOD_ATK_CLASS_1 = -1.0f;
    public static final float MOD_ATK_CLASS_3 = 3.0f;
    public static final float MOD_ATK_CLASS_4 = 7.0f;
    public static final int LVL_SMITE_CLASS_3 = 5;
    public static final int LVL_SMITE_CLASS_4 = 10;
    public static final int COST_LVL_CLASS_3_5 = 10;
    public static final int COST_LVL_CLASS_4 = 15;
    public static final int COST_ITEM_CLASS_4 = 1;
    private static final IItemPropertyGetter BLOCKING_GETTER = (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;

    public ItemLaserBlade() {
        super(ToLaserBlade.MATERIAL_LASER);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setNoRepair();
        this.material = ToLaserBlade.MATERIAL_LASER;
        this.attackDamage = 3.0f + this.material.func_78000_c();
        this.attackSpeed = -1.2f;
        this.func_185043_a(new ResourceLocation("blocking"), BLOCKING_GETTER);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenseLaserBladeBehavior());
    }

    public static NBTTagCompound setPerformance(ItemStack stack, float modSpeed, float modAttack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74776_a(KEY_SPD, modSpeed);
        nbt.func_74776_a(KEY_ATK, modAttack);
        return nbt;
    }

    public static int getColorFromNBT(ItemStack stack, String keyColor, String keyIsSubColor, int defaultColor) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b(keyColor, 3)) {
            int color = nbt.func_74762_e(keyColor);
            if (keyIsSubColor != null && nbt.func_74767_n(keyIsSubColor)) {
                color = ~color | 0xFF000000;
            }
            return color;
        }
        return defaultColor;
    }

    public static NBTTagCompound setColors(ItemStack stack, int colorGrip, int colorCore, int colorHalo, boolean isSubColorCore, boolean isSubColorHalo) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74768_a(KEY_COLOR_GRIP, colorGrip);
        nbt.func_74768_a(KEY_COLOR_CORE, colorCore);
        nbt.func_74768_a(KEY_COLOR_HALO, colorHalo);
        nbt.func_74757_a(KEY_IS_SUB_COLOR_CORE, isSubColorCore);
        nbt.func_74757_a(KEY_IS_SUB_COLOR_HALO, isSubColorHalo);
        return nbt;
    }

    public static boolean checkColors(ItemStack stack, int colorGrip, int colorCore, int colorHalo, boolean isSubColorCore, boolean isSubColorHalo) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (!nbt.func_150297_b(KEY_COLOR_GRIP, 3)) {
            nbt.func_74768_a(KEY_COLOR_GRIP, -1);
        }
        if (colorGrip != nbt.func_74762_e(KEY_COLOR_GRIP)) {
            return false;
        }
        if (!nbt.func_150297_b(KEY_COLOR_CORE, 3)) {
            nbt.func_74768_a(KEY_COLOR_CORE, -1);
        }
        if (colorCore != nbt.func_74762_e(KEY_COLOR_CORE)) {
            return false;
        }
        if (!nbt.func_150297_b(KEY_COLOR_HALO, 3)) {
            nbt.func_74768_a(KEY_COLOR_HALO, colors[0]);
        }
        if (colorHalo != nbt.func_74762_e(KEY_COLOR_HALO)) {
            return false;
        }
        if (!nbt.func_74764_b(KEY_IS_SUB_COLOR_CORE)) {
            nbt.func_74757_a(KEY_IS_SUB_COLOR_CORE, false);
        }
        if (isSubColorCore != nbt.func_74767_n(KEY_IS_SUB_COLOR_CORE)) {
            return false;
        }
        if (!nbt.func_74764_b(KEY_IS_SUB_COLOR_HALO)) {
            nbt.func_74757_a(KEY_IS_SUB_COLOR_HALO, false);
        }
        return isSubColorHalo == nbt.func_74767_n(KEY_IS_SUB_COLOR_HALO);
    }

    public static NBTTagCompound setPerformanceClass1(ItemStack stack, int colorHalo) {
        ItemLaserBlade.setPerformance(stack, 0.0f, -1.0f);
        return ItemLaserBlade.setColors(stack, -1, -1, colorHalo, false, false);
    }

    public static NBTTagCompound setPerformanceClass2(ItemStack stack) {
        ItemLaserBlade.setPerformance(stack, 0.0f, 0.0f);
        return ItemLaserBlade.setColors(stack, -1, -1, colors[0], false, false);
    }

    public static NBTTagCompound setPerformanceClass3(ItemStack stack, int colorHalo) {
        stack.func_77966_a(Enchantment.func_180305_b((String)"smite"), 5);
        NBTTagCompound nbt = ItemLaserBlade.setPerformance(stack, 1.2f, 3.0f);
        if (ItemLaserBlade.checkColors(stack, -1, -1, colors[0], false, false)) {
            return ItemLaserBlade.setColors(stack, -1, -1, colorHalo, false, false);
        }
        return nbt;
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stackOut = event.crafting;
        if (stackOut.func_77973_b() != this) {
            return;
        }
        NBTTagCompound nbt = stackOut.func_77978_p();
        if (nbt == null) {
            nbt = ItemLaserBlade.setColors(stackOut, -1, -1, colors[0], false, false);
        }
        if (nbt.func_74764_b(KEY_IS_CRAFTING)) {
            nbt.func_82580_o(KEY_IS_CRAFTING);
            return;
        }
        ItemLaserBlade.changeBladeColorByBiome(nbt, event.player);
    }

    public static boolean changeBladeColorByItem(NBTTagCompound nbt, ItemStack stack) {
        if (nbt == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemDye) {
            int color = dyeColors[15 - (stack.func_77952_i() & 0xF)] | 0xFF000000;
            if (nbt.func_150297_b(KEY_COLOR_CORE, 3) && nbt.func_74762_e(KEY_COLOR_CORE) == color) {
                return false;
            }
            nbt.func_74768_a(KEY_COLOR_CORE, color);
            return true;
        }
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            if (block instanceof BlockCarpet) {
                int color = dyeColors[stack.func_77960_j() & 0xF] | 0xFF000000;
                if (nbt.func_150297_b(KEY_COLOR_GRIP, 3) && nbt.func_74762_e(KEY_COLOR_GRIP) == color) {
                    return false;
                }
                nbt.func_74768_a(KEY_COLOR_GRIP, color);
                return true;
            }
            if (block instanceof BlockStainedGlass) {
                int color = dyeColors[stack.func_77960_j() & 0xF] | 0xFF000000;
                if (nbt.func_150297_b(KEY_COLOR_HALO, 3) && nbt.func_74762_e(KEY_COLOR_HALO) == color) {
                    return false;
                }
                nbt.func_74768_a(KEY_COLOR_HALO, color);
                return true;
            }
        }
        return false;
    }

    public static void changeBladeColorByBiome(NBTTagCompound nbt, EntityPlayer player) {
        World world = player.field_70170_p;
        Biome biome = world.getBiomeForCoordsBody(player.func_180425_c());
        if (world.field_73011_w.getDimension() == -1 || biome instanceof BiomeHell) {
            boolean isSubColorCore = nbt.func_74767_n(KEY_IS_SUB_COLOR_CORE);
            nbt.func_74757_a(KEY_IS_SUB_COLOR_CORE, !isSubColorCore);
        } else if (world.field_73011_w.getDimension() == 1 || biome instanceof BiomeEnd) {
            boolean isSubColorHalo = nbt.func_74767_n(KEY_IS_SUB_COLOR_HALO);
            nbt.func_74757_a(KEY_IS_SUB_COLOR_HALO, !isSubColorHalo);
        } else if (biome instanceof BiomeVoid) {
            nbt.func_74768_a(KEY_COLOR_CORE, colors[7]);
            nbt.func_74768_a(KEY_COLOR_HALO, colors[7]);
        } else {
            float temp = biome.func_185353_n();
            if (temp > 1.5f) {
                nbt.func_74768_a(KEY_COLOR_HALO, colors[5]);
            } else if (temp > 1.0f) {
                nbt.func_74768_a(KEY_COLOR_HALO, colors[8]);
            } else if (temp > 0.8f) {
                nbt.func_74768_a(KEY_COLOR_HALO, colors[1]);
            } else if (temp >= 0.5f) {
                nbt.func_74768_a(KEY_COLOR_HALO, colors[0]);
            } else if (temp >= 0.2f) {
                nbt.func_74768_a(KEY_COLOR_HALO, colors[2]);
            } else if (temp >= -0.25f) {
                nbt.func_74768_a(KEY_COLOR_HALO, colors[3]);
            } else {
                nbt.func_74768_a(KEY_COLOR_HALO, colors[4]);
            }
        }
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent event) {
        ItemStack output;
        String name;
        ItemStack left = event.getItemInput();
        if (left.func_77973_b() == this && !left.func_77948_v() && event.getIngredientInput().func_190926_b() && ("GIFT".equals(name = (output = event.getItemResult()).func_82833_r()) || "\u304a\u305f\u304b\u3089".equals(name))) {
            ItemLaserBlade.setPerformanceClass3(output, colors[1]);
            output.func_135074_t();
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        float atk;
        NBTTagCompound nbt;
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        String name = event.getName();
        if (left.func_77973_b() != this) {
            return;
        }
        ItemStack output = left.func_77946_l();
        if (right.func_77973_b() == Items.field_151156_bN) {
            if (this.upgradeClass4(output)) {
                this.changeDisplayNameOnAnvil(left, output, name);
                event.setCost(15);
                event.setMaterialCost(1);
                event.setOutput(output);
                return;
            }
        } else if (right.func_77973_b() == Items.field_151072_bj) {
            if (this.upgradeEnchantment(output, Enchantments.field_77334_n)) {
                this.changeDisplayNameOnAnvil(left, output, name);
                event.setCost(10);
                event.setMaterialCost(1);
                event.setOutput(output);
                return;
            }
        } else if (right.func_77973_b() == Items.field_151061_bv) {
            if (this.upgradeEnchantment(output, Enchantments.field_191530_r)) {
                this.changeDisplayNameOnAnvil(left, output, name);
                event.setCost(10);
                event.setMaterialCost(1);
                event.setOutput(output);
                return;
            }
        } else if (right.func_77973_b() == Items.field_179563_cD) {
            if (this.upgradeEnchantment(output, Enchantments.field_185306_r)) {
                this.changeDisplayNameOnAnvil(left, output, name);
                event.setCost(10);
                event.setMaterialCost(1);
                event.setOutput(output);
                return;
            }
        } else if (right.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)right.func_77973_b()).func_179223_d();
            if (block == Blocks.field_150451_bX) {
                if (this.upgradeClass3Speed(output)) {
                    this.changeDisplayNameOnAnvil(left, output, name);
                    event.setCost(10);
                    event.setMaterialCost(1);
                    event.setOutput(output);
                    return;
                }
            } else if (block == Blocks.field_150484_ah) {
                if (this.upgradeClass3Attack(output)) {
                    this.changeDisplayNameOnAnvil(left, output, name);
                    event.setCost(10);
                    event.setMaterialCost(1);
                    event.setOutput(output);
                    return;
                }
            } else if (block == Blocks.field_150426_aN) {
                if (this.upgradeClass3Smite(output)) {
                    this.changeDisplayNameOnAnvil(left, output, name);
                    event.setCost(10);
                    event.setMaterialCost(1);
                    event.setOutput(output);
                    return;
                }
            } else if (block == Blocks.field_150475_bE && this.upgradeEnchantment(output, Enchantments.field_185304_p)) {
                this.changeDisplayNameOnAnvil(left, output, name);
                event.setCost(10);
                event.setMaterialCost(1);
                event.setOutput(output);
                return;
            }
        } else if (right.func_77973_b() == Items.field_151144_bL && (nbt = output.func_77978_p()) != null && (atk = nbt.func_74760_g(KEY_ATK)) >= 7.0f && atk < 2041.0f) {
            this.changeDisplayNameOnAnvil(left, output, name);
            nbt.func_74776_a(KEY_ATK, atk + 1.0f);
            event.setCost((int)atk / 100 + 10);
            event.setMaterialCost(1);
            event.setOutput(output);
            return;
        }
        if (ItemLaserBlade.changeBladeColorByItem(output.func_77978_p(), right)) {
            this.changeDisplayNameOnAnvil(left, output, name);
            event.setCost(1);
            event.setMaterialCost(1);
            event.setOutput(output);
            return;
        }
    }

    private void changeDisplayNameOnAnvil(ItemStack left, ItemStack output, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            if (left.func_82837_s()) {
                output.func_135074_t();
            }
        } else if (!name.equals(left.func_82833_r())) {
            output.func_151001_c(name);
        }
    }

    public boolean upgradeClass3Speed(ItemStack stack) {
        float spd;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if ((spd = nbt.func_74760_g(KEY_SPD)) < 1.2f) {
            nbt.func_74776_a(KEY_SPD, 1.2f);
            return true;
        }
        return false;
    }

    public boolean upgradeClass3Attack(ItemStack stack) {
        float atk;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if ((atk = nbt.func_74760_g(KEY_ATK)) < 7.0f) {
            float newAtk = atk < 3.0f ? 3.0f : 7.0f;
            nbt.func_74776_a(KEY_ATK, newAtk);
            return true;
        }
        return false;
    }

    public boolean upgradeClass3Smite(ItemStack stack) {
        Map mapOld = EnchantmentHelper.func_82781_a((ItemStack)stack);
        Integer lvlSmite = (Integer)mapOld.get(Enchantments.field_185303_l);
        if (lvlSmite == null || lvlSmite < 10) {
            HashMap mapNew = new HashMap();
            int newSmiteLvl = lvlSmite == null || lvlSmite < 5 ? 5 : 10;
            for (Map.Entry enchOld : mapOld.entrySet()) {
                Enchantment key = (Enchantment)enchOld.getKey();
                if (!key.func_191560_c(Enchantments.field_185303_l)) continue;
                mapNew.put(key, enchOld.getValue());
            }
            mapNew.put(Enchantments.field_185303_l, newSmiteLvl);
            EnchantmentHelper.func_82782_a(mapNew, (ItemStack)stack);
            return true;
        }
        return false;
    }

    public boolean upgradeClass4(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            stack.func_77966_a(Enchantments.field_185303_l, 10);
            nbt = stack.func_77978_p();
            nbt.func_74776_a(KEY_ATK, 7.0f);
            nbt.func_74776_a(KEY_SPD, 1.2f);
            return true;
        }
        boolean isAtkClass4 = false;
        boolean isSpdClass4 = false;
        boolean isSmiteClass4 = false;
        if (nbt.func_74760_g(KEY_ATK) < 7.0f) {
            nbt.func_74776_a(KEY_ATK, 7.0f);
        } else {
            isAtkClass4 = true;
        }
        if (nbt.func_74760_g(KEY_SPD) < 1.2f) {
            nbt.func_74776_a(KEY_SPD, 1.2f);
        } else {
            isSpdClass4 = true;
        }
        HashMap<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        Integer lvlSmite = (Integer)map.get(Enchantments.field_185303_l);
        if (lvlSmite == null) {
            HashMap<Enchantment, Integer> mapNew = new HashMap<Enchantment, Integer>();
            for (Map.Entry entry : map.entrySet()) {
                Enchantment key = (Enchantment)entry.getKey();
                if (!key.func_191560_c(Enchantments.field_185303_l)) continue;
                mapNew.put(key, (Integer)entry.getValue());
            }
            map = mapNew;
            map.put(Enchantments.field_185303_l, 10);
        } else if (lvlSmite < 10) {
            map.put(Enchantments.field_185303_l, 10);
        } else {
            isSmiteClass4 = true;
        }
        if (isAtkClass4 && isSpdClass4 && isSmiteClass4) {
            return false;
        }
        EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
        return true;
    }

    private boolean isCompatibleWith(Enchantment e1, Enchantment e2) {
        return e1.func_191560_c(e2) || e1.equals(e2) || e1 == Enchantments.field_185306_r && e2 == Enchantments.field_185304_p || e1 == Enchantments.field_185304_p && e2 == Enchantments.field_185306_r;
    }

    public boolean upgradeEnchantment(ItemStack stack, Enchantment enchantment) {
        Map mapOld = EnchantmentHelper.func_82781_a((ItemStack)stack);
        Integer lvl = (Integer)mapOld.get(enchantment);
        int maxLvl = enchantment.func_77325_b();
        if (lvl == null || lvl < maxLvl) {
            HashMap mapNew = new HashMap();
            for (Map.Entry enchOld : mapOld.entrySet()) {
                Enchantment key = (Enchantment)enchOld.getKey();
                if (!this.isCompatibleWith(key, enchantment)) continue;
                mapNew.put(key, enchOld.getValue());
            }
            mapNew.put(enchantment, maxLvl);
            EnchantmentHelper.func_82782_a(mapNew, (ItemStack)stack);
            return true;
        }
        return false;
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return ToLaserBladeConfig.server.isEnabledBlockingWithLaserBlade;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (ToLaserBladeConfig.server.isEnabledBlockingWithLaserBlade) {
            return EnumAction.BLOCK;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        if (ToLaserBladeConfig.server.isEnabledBlockingWithLaserBlade) {
            return 72000;
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        EnumAction offhandItemAction;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ToLaserBladeConfig.server.isEnabledBlockingWithLaserBlade && (offhandItemAction = playerIn.func_184592_cb().func_77975_n()) != EnumAction.BOW) {
            playerIn.func_184598_c(handIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public float func_150931_i() {
        return this.attackDamage;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return ToLaserBladeConfig.server.laserBladeEfficiency;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        return this.material.func_77996_d();
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            float modDamage = 0.0f;
            float modSpeed = 0.0f;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                if (!nbt.func_74764_b(KEY_SPD)) {
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185303_l, (ItemStack)stack) >= 10) {
                        nbt.func_74776_a(KEY_SPD, 1.2f);
                    } else {
                        nbt.func_74776_a(KEY_SPD, 0.0f);
                    }
                    ItemLaserBlade.checkColors(stack, -1, -1, colors[0], false, false);
                }
                modDamage = nbt.func_74760_g(KEY_ATK);
                modSpeed = nbt.func_74760_g(KEY_SPD);
            } else {
                ItemLaserBlade.setPerformanceClass2(stack);
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(this.attackDamage + modDamage), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)(this.attackSpeed + modSpeed), 0));
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ColorHandler
    implements IItemColor {
        public static final ColorHandler INSTANCE = new ColorHandler();

        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (ToLaserBladeConfig.client.isEnabledLaserBlade3DModel) {
                return -1;
            }
            switch (tintIndex) {
                case 0: {
                    return ItemLaserBlade.getColorFromNBT(stack, ItemLaserBlade.KEY_COLOR_GRIP, null, -1);
                }
                case 1: {
                    return ItemLaserBlade.getColorFromNBT(stack, ItemLaserBlade.KEY_COLOR_HALO, ItemLaserBlade.KEY_IS_SUB_COLOR_HALO, colors[0]);
                }
                case 2: {
                    return ItemLaserBlade.getColorFromNBT(stack, ItemLaserBlade.KEY_COLOR_CORE, ItemLaserBlade.KEY_IS_SUB_COLOR_CORE, -1);
                }
            }
            return -1;
        }
    }
}

