/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.block;

import meldexun.better_diving.block.BlockStructurePart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class BlockEnergyGenerator
extends BlockStructurePart {
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public int getEnergyStored(World world, BlockPos pos) {
        IEnergyStorage ienergy;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && (ienergy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return ienergy.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(World world, BlockPos pos) {
        IEnergyStorage ienergy;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && (ienergy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return ienergy.getMaxEnergyStored();
        }
        return 0;
    }

    public int receiveEnergy(World world, BlockPos pos, int energy) {
        IEnergyStorage ienergy;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && (ienergy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return ienergy.receiveEnergy(energy, false);
        }
        return 0;
    }

    public int extractEnergy(World world, BlockPos pos, int energy) {
        IEnergyStorage ienergy;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && (ienergy = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return ienergy.extractEnergy(energy, false);
        }
        return 0;
    }
}

