/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.block;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import meldexun.better_diving.block.BlockUnderwaterBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOutcrop
extends BlockUnderwaterBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final AxisAlignedBB OUTCROP_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.7, 0.9);
    private int drop;
    private Map<Item, Integer> dropList = new HashMap<Item, Integer>();

    public BlockOutcrop() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
        this.func_149711_c(0.4f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLiquid.field_176367_b, FACING});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(Block.RANDOM.nextInt(4));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return OUTCROP_AABB;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        double d = rand.nextDouble() * (double)this.drop;
        for (Map.Entry<Item, Integer> entry : this.dropList.entrySet()) {
            if (!((d -= (double)entry.getValue().intValue()) <= 0.0)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addDrop(Item item, int weight) {
        this.drop += weight;
        this.dropList.put(item, weight);
    }
}

