/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSeabaseLadder
extends BlockHorizontal {
    protected static final AxisAlignedBB LADDER_EAST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.125, 0.9375, 1.0, 0.875);
    protected static final AxisAlignedBB LADDER_WEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.125, 0.1875, 1.0, 0.875);
    protected static final AxisAlignedBB LADDER_SOUTH_AABB = new AxisAlignedBB(0.125, 0.0, 0.8125, 0.875, 1.0, 0.9375);
    protected static final AxisAlignedBB LADDER_NORTH_AABB = new AxisAlignedBB(0.125, 0.0, 0.0625, 0.875, 1.0, 0.1875);
    protected static final PropertyInteger PART = PropertyInteger.func_177719_a((String)"part", (int)0, (int)3);

    public BlockSeabaseLadder() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            case NORTH: {
                return LADDER_NORTH_AABB;
            }
            case SOUTH: {
                return LADDER_SOUTH_AABB;
            }
            case WEST: {
                return LADDER_WEST_AABB;
            }
            case EAST: {
                return LADDER_EAST_AABB;
            }
        }
        return LADDER_NORTH_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176733_a((double)placer.field_70177_z));
        Block blockDown = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block blockUp = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (blockDown != this && blockUp != this) {
            return state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(0));
        }
        if (blockDown != this) {
            return state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(1));
        }
        if (blockUp == this) {
            return state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(2));
        }
        return state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(3));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int part = (Integer)state.func_177229_b((IProperty)PART);
        Block blockDown = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block blockUp = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (part != 0 && blockDown != this && blockUp != this) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(0)));
        } else if (part != 1 && blockDown != this && blockUp == this) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(1)));
        } else if (part != 2 && blockDown == this && blockUp == this) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(2)));
        } else if (part != 3 && blockDown == this && blockUp != this) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(3)));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(meta / 4));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b() + 4 * (Integer)state.func_177229_b((IProperty)PART);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, PART});
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

