/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.block;

import java.util.Random;
import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.block.BlockStructurePart;
import meldexun.better_diving.structure.SeabaseStructure;
import meldexun.better_diving.structure.modules.SeabaseModule;
import meldexun.better_diving.tileentity.TileEntityStructure;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStructure
extends Block {
    public BlockStructure() {
        super(Material.field_151573_f);
        this.field_149781_w = Float.MAX_VALUE;
        this.field_149782_v = -1.0f;
        this.field_149784_t = 3;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityStructure();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tileEntity;
        if (world instanceof World && !((World)world).field_72995_K && world.func_180495_p(neighbor).func_177230_c() instanceof BlockStructurePart && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityStructure) {
            TileEntityStructure tileEntityStructure = (TileEntityStructure)tileEntity;
            tileEntityStructure.getModule().addStructurePart(neighbor);
        }
    }

    public void placeBlock(World world, BlockPos pos, int flags, SeabaseModule module, boolean isDoor) {
        if (!world.field_72995_K) {
            world.func_180501_a(pos, this.func_176223_P(), flags);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityStructure) {
                TileEntityStructure tileEntityStructure = (TileEntityStructure)tileEntity;
                tileEntityStructure.setModule(module);
                tileEntityStructure.setDoor(isDoor);
                if (!isDoor) {
                    this.checkForNearbyModules(world, pos, module);
                }
            }
        }
    }

    private void checkForNearbyModules(World world, BlockPos pos, SeabaseModule module) {
        for (int i = 0; i < 6; ++i) {
            TileEntityStructure tileEntityStructure;
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(EnumFacing.values()[i]));
            if (!(tileEntity instanceof TileEntityStructure) || (tileEntityStructure = (TileEntityStructure)tileEntity).isDoor()) continue;
            SeabaseModule otherModule = tileEntityStructure.getModule();
            if (otherModule != module) {
                BetterDiving.logger.info(module.getStructure() + " &&& " + otherModule.getStructure());
            }
            if (otherModule == module || otherModule.getStructure() == module.getStructure()) continue;
            SeabaseStructure.merge(otherModule.getStructure(), module.getStructure());
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileEntityStructure tileEntity = (TileEntityStructure)worldIn.func_175625_s(pos);
            if (playerIn.func_70093_af()) {
                tileEntity.getModule().destroy();
            } else {
                BetterDiving.logger.info((Object)tileEntity.getModule());
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }
}

