/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.block;

import javax.annotation.Nullable;
import meldexun.better_diving.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockUnderwaterBlock
extends Block {
    public BlockUnderwaterBlock() {
        super(Material.field_151586_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185855_h);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLiquid.field_176367_b});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        if (!this.checkBottom(worldIn, pos)) {
            return false;
        }
        if (!this.checkTop(worldIn, pos)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.isFullCubeOrWater(worldIn.func_180495_p(pos.func_177972_a(EnumFacing.func_176731_b((int)i))))) continue;
            return false;
        }
        return true;
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        if (!this.checkBottom(world, pos)) {
            return false;
        }
        if (!this.checkTop(world, pos)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.checkSide(world, pos, EnumFacing.func_176731_b((int)i))) continue;
            return false;
        }
        return true;
    }

    public boolean checkBottom(World world, BlockPos pos) {
        BlockPos position = pos.func_177977_b();
        Material material = world.func_180495_p(position).func_185904_a();
        return material == Material.field_151571_B || material == Material.field_151578_c || material == Material.field_151576_e || material == Material.field_151595_p;
    }

    public boolean checkTop(World world, BlockPos pos) {
        BlockPos position = pos.func_177984_a();
        IBlockState state = world.func_180495_p(position);
        if (state.func_185904_a() == Material.field_151586_h) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150350_a) {
            if (BlockHelper.isWaterBlock(world.func_180495_p(position.func_177984_a()))) {
                return true;
            }
            for (int i = 0; i < 4; ++i) {
                if (!BlockHelper.isWaterBlock(world.func_180495_p(position.func_177972_a(EnumFacing.func_176731_b((int)i))), 6)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkSide(World world, BlockPos pos, EnumFacing facing) {
        BlockPos position = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(position);
        if (this.isFullCubeOrWater(state)) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150350_a) {
            if (BlockHelper.isWaterBlock(world.func_180495_p(position.func_177984_a()))) {
                return true;
            }
            if (BlockHelper.isWaterBlock(world.func_180495_p(position.func_177972_a(facing.func_176735_f())), 6)) {
                return true;
            }
            if (BlockHelper.isWaterBlock(world.func_180495_p(position.func_177972_a(facing)), 6)) {
                return true;
            }
            if (BlockHelper.isWaterBlock(world.func_180495_p(position.func_177972_a(facing.func_176746_e())), 6)) {
                return true;
            }
        }
        return false;
    }

    public boolean isFullCubeOrWater(IBlockState state) {
        return state.func_185904_a() == Material.field_151586_h || state.func_185917_h();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
            this.func_176226_b(worldIn, pos, state, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        worldIn.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
    }
}

