/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.capability;

import meldexun.better_diving.capability.diving.CapabilityDivingAttributesProvider;
import meldexun.better_diving.capability.energy.CapabilityEnergyStorageProvider;
import meldexun.better_diving.capability.inventory.CapabilityItemHandlerProvider;
import meldexun.better_diving.capability.item.energy.CapabilityEnergyStorageItemProvider;
import meldexun.better_diving.capability.item.inventory.CapabilityItemHandlerItemProvider;
import meldexun.better_diving.capability.item.oxygen.CapabilityOxygenProvider;
import meldexun.better_diving.entity.EntitySeamoth;
import meldexun.better_diving.item.ItemDivingChest;
import meldexun.better_diving.item.ItemEnergyStorage;
import meldexun.better_diving.item.ItemSeamoth;
import meldexun.better_diving.item.ItemTool;
import meldexun.better_diving.tileentity.TileEntityEnergyGenerator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="better_diving")
public class AttachCapabilitiesEventHandler {
    private AttachCapabilitiesEventHandler() {
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEntityEvent(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityPlayer) {
            event.addCapability(CapabilityDivingAttributesProvider.LOCATION_DIVING_ATTRIBUTES, (ICapabilityProvider)CapabilityDivingAttributesProvider.createProvider((EntityPlayer)entity));
        } else if (entity instanceof EntitySeamoth) {
            event.addCapability(CapabilityItemHandlerProvider.LOCATION_ITEM_STACK_HANDLER, (ICapabilityProvider)CapabilityItemHandlerProvider.createProvider(5));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesTileEntityEvent(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tileEntity = (TileEntity)event.getObject();
        if (tileEntity instanceof TileEntityEnergyGenerator) {
            event.addCapability(CapabilityEnergyStorageProvider.LOCATION_ENERGY_STORAGE, (ICapabilityProvider)CapabilityEnergyStorageProvider.createProvider((TileEntityEnergyGenerator)tileEntity));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesItemStackEvent(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        Item item = stack.func_77973_b();
        if (item instanceof ItemDivingChest) {
            event.addCapability(CapabilityOxygenProvider.LOCATION_OXYGEN, (ICapabilityProvider)CapabilityOxygenProvider.createProvider(stack));
        } else if (item instanceof ItemEnergyStorage) {
            event.addCapability(CapabilityEnergyStorageProvider.LOCATION_ENERGY_STORAGE, (ICapabilityProvider)CapabilityEnergyStorageItemProvider.createProvider(stack));
        } else if (item instanceof ItemSeamoth) {
            event.addCapability(CapabilityItemHandlerProvider.LOCATION_ITEM_STACK_HANDLER, (ICapabilityProvider)CapabilityItemHandlerItemProvider.createProvider(stack, 5));
        } else if (item instanceof ItemTool) {
            event.addCapability(CapabilityItemHandlerProvider.LOCATION_ITEM_STACK_HANDLER, (ICapabilityProvider)CapabilityItemHandlerItemProvider.createProvider(stack, 1));
        }
    }
}

