/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.capability.diving;

import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.capability.diving.ICapabilityDivingAttributes;
import meldexun.better_diving.capability.item.oxygen.CapabilityOxygenProvider;
import meldexun.better_diving.capability.item.oxygen.ICapabilityOxygen;
import meldexun.better_diving.entity.EntitySeamoth;
import meldexun.better_diving.integration.ArtemisLib;
import meldexun.better_diving.integration.MatterOverdrive;
import meldexun.better_diving.integration.Metamorph;
import meldexun.better_diving.integration.Vampirism;
import meldexun.better_diving.item.AbstractItemDivingGear;
import meldexun.better_diving.item.ItemSeaglide;
import meldexun.better_diving.network.packet.CPacketSyncPlayerInput;
import meldexun.better_diving.network.packet.SPacketSyncOxygen;
import meldexun.better_diving.util.BetterDivingConfig;
import meldexun.better_diving.util.EntityHelper;
import meldexun.better_diving.util.MovementHelper;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapabilityDivingAttributes
implements ICapabilityDivingAttributes {
    private final EntityPlayer player;
    private int oxygen = this.getOxygenCapacity();
    private boolean isDiving = false;
    private boolean prevIsDiving = false;
    private float divingTick;
    private float prevDivingTick;
    private float divingTickHorizontal;
    private float prevDivingTickHorizontal;
    private float divingTickVertical;
    private float prevDivingTickVertical;
    private boolean isInSeamoth;
    private boolean isPrevInSeamoth;

    public CapabilityDivingAttributes() {
        this(null);
    }

    public CapabilityDivingAttributes(EntityPlayer player) {
        this.player = player;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleDiving() {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        this.prevIsDiving = this.isDiving;
        if (this.player.field_71075_bZ.field_75100_b || this.player.func_184613_cA()) {
            this.isDiving = false;
        } else if (this.prevIsDiving) {
            if (this.player.func_184218_aH()) {
                this.isDiving = false;
            } else if (this.player.func_70055_a(Material.field_151586_h)) {
                this.isDiving = settings.field_74351_w.func_151470_d() && !settings.field_74368_y.func_151470_d();
            } else {
                Vec3d vec = this.player.func_174791_d();
                AxisAlignedBB aabb = new AxisAlignedBB(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, vec.field_72450_a + 0.6, vec.field_72448_b + 1.8, vec.field_72449_c + 0.6);
                this.isDiving = this.player.field_70170_p.func_184143_b(aabb);
            }
        } else {
            this.isDiving = !this.player.func_184218_aH() && this.player.func_70055_a(Material.field_151586_h) && settings.field_74351_w.func_151470_d() && !settings.field_74368_y.func_151470_d() && settings.field_151444_V.func_151470_d();
        }
        this.prevDivingTick = this.divingTick;
        this.prevDivingTickHorizontal = this.divingTickHorizontal;
        this.prevDivingTickVertical = this.divingTickVertical;
        if (this.isDiving) {
            this.divingTick = Math.min(this.divingTick + 0.1f, 1.0f);
            this.divingTickHorizontal = settings.field_74370_x.func_151470_d() && !settings.field_74366_z.func_151470_d() ? Math.min(this.divingTickHorizontal + 0.1f, 1.0f) : (!settings.field_74370_x.func_151470_d() && settings.field_74366_z.func_151470_d() ? Math.max(this.divingTickHorizontal - 0.1f, -1.0f) : (this.divingTickHorizontal < 0.0f ? Math.min(this.divingTickHorizontal + 0.1f, 0.0f) : (this.divingTickHorizontal > 0.0f ? Math.max(this.divingTickHorizontal - 0.1f, 0.0f) : 0.0f)));
            this.divingTickVertical = settings.field_74314_A.func_151470_d() && !settings.field_74311_E.func_151470_d() ? Math.min(this.divingTickVertical + 0.1f, 1.0f) : (!settings.field_74314_A.func_151470_d() && settings.field_74311_E.func_151470_d() ? Math.max(this.divingTickVertical - 0.1f, -1.0f) : (this.divingTickVertical < 0.0f ? Math.min(this.divingTickVertical + 0.1f, 0.0f) : (this.divingTickVertical > 0.0f ? Math.max(this.divingTickVertical - 0.1f, 0.0f) : 0.0f)));
        } else {
            this.divingTick = Math.max(this.divingTick - 0.1f, 0.0f);
            this.divingTickHorizontal = this.divingTickHorizontal < 0.0f ? Math.min(this.divingTickHorizontal + 0.1f, 0.0f) : (this.divingTickHorizontal > 0.0f ? Math.max(this.divingTickHorizontal - 0.1f, 0.0f) : 0.0f);
            this.divingTickVertical = this.divingTickVertical < 0.0f ? Math.min(this.divingTickVertical + 0.1f, 0.0f) : (this.divingTickVertical > 0.0f ? Math.max(this.divingTickVertical - 0.1f, 0.0f) : 0.0f);
        }
        BetterDiving.network.sendToServer((IMessage)new CPacketSyncPlayerInput(this.isDiving, this.divingTick, this.divingTickHorizontal, this.divingTickVertical));
    }

    @Override
    public void tick() {
        this.isPrevInSeamoth = this.isInSeamoth;
        this.isInSeamoth = this.player.func_184187_bx() instanceof EntitySeamoth;
        this.handleMovement();
        if (this.player.field_70170_p.field_72995_K) {
            this.handleDiving();
            if (!BetterDivingConfig.getInstance().general.oxygenSyncPackets) {
                this.handleOxygen();
            }
        } else {
            this.handleOxygen();
            if (BetterDivingConfig.getInstance().general.oxygenSyncPackets) {
                BetterDiving.network.sendTo((IMessage)new SPacketSyncOxygen(this.player), (EntityPlayerMP)this.player);
            }
        }
    }

    @Override
    public void updateSize() {
        if (BetterDivingConfig.getInstance().modules.divingMovement && BetterDivingConfig.getInstance().general.playerResizing) {
            if (ArtemisLib.loaded && BetterDivingConfig.getInstance().general.artemisLibCompatibility) {
                if (this.isInSeamoth) {
                    EntityHelper.updatePlayerSize(this.player, this.player.field_70131_O * 0.85f, this.player.field_70130_N, this.player.field_70131_O * 0.646875f);
                } else if (this.isPrevInSeamoth) {
                    this.player.eyeHeight = this.player.getDefaultEyeHeight();
                }
                if (this.isDiving) {
                    EntityHelper.updatePlayerSize(this.player, this.player.field_70131_O * 0.333333f, this.player.field_70130_N, this.player.field_70131_O * 0.222222f);
                } else if (this.prevIsDiving) {
                    this.player.eyeHeight = this.player.getDefaultEyeHeight();
                }
            } else {
                if (this.isInSeamoth) {
                    EntityHelper.updatePlayerSize(this.player, 1.53f, 0.6f, 1.164375f);
                } else if (this.isPrevInSeamoth) {
                    EntityHelper.resetPlayerSize(this.player);
                }
                if (this.isDiving) {
                    EntityHelper.updatePlayerSize(this.player, 0.6f, 0.6f, 0.4f);
                } else if (this.prevIsDiving) {
                    EntityHelper.resetPlayerSize(this.player);
                }
            }
        }
    }

    protected void handleMovement() {
        if (BetterDivingConfig.getInstance().modules.divingMovement && this.player.func_70090_H() && !this.player.field_71075_bZ.field_75100_b && !this.player.func_184218_aH()) {
            if (!this.player.field_70170_p.field_72995_K) {
                if (!BetterDivingConfig.getInstance().general.vanillaDivingMovement) {
                    this.player.field_70181_x += 0.02;
                } else {
                    this.player.field_70181_x += 0.015;
                    if (this.isDiving) {
                        this.player.field_70181_x += 0.005;
                    }
                }
            } else {
                GameSettings settings = Minecraft.func_71410_x().field_71474_y;
                boolean inputForward = settings.field_74351_w.func_151470_d();
                boolean inputBack = settings.field_74368_y.func_151470_d();
                boolean inputRight = settings.field_74366_z.func_151470_d();
                boolean inputLeft = settings.field_74370_x.func_151470_d();
                boolean inputUp = settings.field_74314_A.func_151470_d();
                boolean inputDown = settings.field_74311_E.func_151470_d();
                float rotationPitch = this.player.field_70125_A;
                float rotationYaw = this.player.field_70177_z;
                double slow = this.calculateSlow();
                double speed = this.getSwimSpeedFromPlayer();
                double strafe = 0.0;
                double forward = 0.0;
                double up = 0.0;
                if (inputForward) {
                    forward += 1.0;
                }
                if (inputBack) {
                    forward -= 1.0;
                }
                if (inputRight) {
                    strafe -= 1.0;
                }
                if (inputLeft) {
                    strafe += 1.0;
                }
                if (inputUp) {
                    up += 1.0;
                }
                if (inputDown) {
                    up -= 1.0;
                }
                if (!BetterDivingConfig.getInstance().general.vanillaDivingMovement) {
                    this.player.field_70181_x += 0.02;
                    if (inputDown) {
                        slow *= 0.3;
                    }
                    if (inputUp) {
                        this.player.field_70181_x -= (double)0.04f;
                    }
                    if (inputForward != inputBack || inputRight != inputLeft) {
                        MovementHelper.move2D((Entity)this.player, strafe, forward, -slow, rotationYaw);
                    }
                    if (inputForward != inputBack || inputRight != inputLeft || inputUp != inputDown) {
                        if (inputForward && !inputBack) {
                            if (inputUp && !inputDown) {
                                rotationPitch = (rotationPitch - 90.0f) / 2.0f;
                                up = 0.0;
                            } else if (inputDown && !inputUp) {
                                rotationPitch = (rotationPitch + 90.0f) / 2.0f;
                                up = 0.0;
                            }
                        } else if (inputBack && !inputForward) {
                            if (inputUp && !inputDown) {
                                rotationPitch = (rotationPitch + 90.0f) / 2.0f;
                                up = 0.0;
                            } else if (inputDown && !inputUp) {
                                rotationPitch = (rotationPitch - 90.0f) / 2.0f;
                                up = 0.0;
                            }
                        }
                        if (ItemSeaglide.canUseSeaglide(this.player) && !inputForward) {
                            speed *= 0.4;
                        }
                        this.move3D(this.player, strafe, up, forward, speed, rotationYaw, rotationPitch);
                    }
                } else {
                    this.player.field_70181_x += 0.015;
                    if ((settings.field_151444_V.func_151470_d() || this.player.func_70051_ag()) && inputForward && !inputBack) {
                        this.player.field_70181_x += 0.005;
                        if (inputDown) {
                            slow *= 0.3;
                        }
                        if (inputUp) {
                            this.player.field_70181_x -= (double)0.04f;
                        }
                        MovementHelper.move2D((Entity)this.player, strafe, forward, -slow, rotationYaw);
                        if (inputUp && !inputDown) {
                            rotationPitch = (rotationPitch - 90.0f) / 2.0f;
                            up = 0.0;
                        } else if (inputDown && !inputUp) {
                            rotationPitch = (rotationPitch + 90.0f) / 2.0f;
                            up = 0.0;
                        }
                        this.move3D(this.player, strafe, up, forward, speed, rotationYaw, rotationPitch);
                    } else if (inputDown) {
                        this.player.field_70181_x -= (double)0.04f;
                        MovementHelper.move2D((Entity)this.player, strafe, forward, slow *= 0.7, rotationYaw);
                    }
                }
            }
        }
    }

    protected double calculateSlow() {
        double slow = 0.02;
        ItemStack feet = (ItemStack)this.player.field_71071_by.field_70460_b.get(0);
        double depthStrider = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185300_i, (ItemStack)feet);
        if (depthStrider > 0.0) {
            if (depthStrider > 3.0) {
                depthStrider = 3.0;
            }
            if (!this.player.field_70122_E) {
                depthStrider *= 0.5;
            }
            slow += ((double)this.player.func_70689_ay() - slow) * depthStrider / 3.0;
        }
        return slow * 0.98;
    }

    protected void move3D(EntityPlayer player, double strafe, double up, double forward, double speed, double yaw, double pitch) {
        double d = strafe * strafe + up * up + forward * forward;
        if (d >= 1.0E-4) {
            if ((d = Math.sqrt(d)) < 1.0) {
                d = 1.0;
            }
            d = speed / d;
            strafe *= d;
            up *= d;
            forward *= d;
            double d1 = Math.sin(yaw * 0.017453292);
            double d2 = Math.cos(yaw * 0.017453292);
            double d3 = Math.sin(pitch * 0.017453292);
            double d4 = Math.cos(pitch * 0.017453292);
            double depthStriderFactor = 1.0;
            ItemStack feet = player.func_184582_a(EntityEquipmentSlot.FEET);
            int depthStriderLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185300_i, (ItemStack)feet);
            if (depthStriderLevel > 0) {
                if (depthStriderLevel > 3) {
                    depthStriderLevel = 3;
                }
                depthStriderFactor += 0.42333323333333334 * (double)depthStriderLevel * (!player.field_70122_E ? 0.5 : 1.0);
            }
            player.field_70159_w += (strafe * d2 - forward * d1 * d4) * depthStriderFactor;
            player.field_70181_x += up - forward * d3;
            player.field_70179_y += (forward * d2 * d4 + strafe * d1) * depthStriderFactor;
        }
    }

    protected void handleOxygen() {
        if (BetterDivingConfig.getInstance().modules.oxygenHandling) {
            int airUsage = 0;
            if (!(!this.player.func_70055_a(Material.field_151586_h) || this.player.func_70648_aU() || this.player.func_70644_a(MobEffects.field_76427_o) || this.player.field_71075_bZ.field_75102_a || this.player.func_184187_bx() instanceof EntitySeamoth || Metamorph.hasWaterBreathing((EntityLivingBase)this.player) || Vampirism.hasWaterBreathing((EntityLivingBase)this.player) || MatterOverdrive.hasWaterBreathing((EntityLivingBase)this.player))) {
                ItemStack helm;
                --airUsage;
                if (!(!BetterDivingConfig.getInstance().divingValues.airEfficiency || (helm = (ItemStack)this.player.field_71071_by.field_70460_b.get(3)).func_77973_b() instanceof AbstractItemDivingGear && ((AbstractItemDivingGear)helm.func_77973_b()).isImproved())) {
                    airUsage -= EntityHelper.blocksUnderWater((Entity)this.player) / BetterDivingConfig.getInstance().divingValues.airEfficiencyLimit;
                }
            } else {
                airUsage += 25;
            }
            if (airUsage < 0) {
                this.extractOxygenFromPlayer(-airUsage);
            } else if (airUsage > 0) {
                this.receiveOxygenFromPlayer(airUsage);
            }
            this.player.func_70050_g(this.getOxygenFromPlayer() > 0 ? (int)(this.getOxygenFromPlayerInPercent() * 300.0) : 0);
            if (!this.player.field_70170_p.field_72995_K && this.oxygen <= -20) {
                this.oxygen = 0;
                ((WorldServer)this.player.field_70170_p).func_175739_a(EnumParticleTypes.WATER_BUBBLE, this.player.field_70165_t, this.player.field_70163_u + (double)this.player.field_70131_O * 0.5, this.player.field_70161_v, 8, 0.25, 0.25, 0.25, 0.0, new int[0]);
                this.player.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        }
    }

    @Override
    public void setOxygen(int oxygen) {
        this.oxygen = oxygen;
    }

    @Override
    public int getOxygen() {
        return this.oxygen;
    }

    @Override
    public int getOxygenFromPlayer() {
        int oxygenFromPlayer = this.getOxygen();
        ItemStack helm = (ItemStack)this.player.field_71071_by.field_70460_b.get(3);
        ItemStack chest = (ItemStack)this.player.field_71071_by.field_70460_b.get(2);
        if (helm.func_77973_b() instanceof AbstractItemDivingGear && chest.func_77973_b() instanceof AbstractItemDivingGear) {
            ICapabilityOxygen ioxygen = (ICapabilityOxygen)chest.getCapability(CapabilityOxygenProvider.OXYGEN, null);
            oxygenFromPlayer += ioxygen.getOxygen();
        }
        return oxygenFromPlayer;
    }

    @Override
    public double getOxygenFromPlayerInPercent() {
        return (double)this.getOxygenFromPlayer() / (double)this.getOxygenCapacityFromPlayer();
    }

    @Override
    public int receiveOxygen(int amount) {
        amount = MathHelper.func_76125_a((int)amount, (int)0, (int)(this.getOxygenCapacity() - this.oxygen));
        this.oxygen += amount;
        return amount;
    }

    @Override
    public int receiveOxygenFromPlayer(int amount) {
        if (amount > 0) {
            int amountReceived = this.receiveOxygen(amount);
            int amountToReceive = amount - amountReceived;
            if (amountToReceive > 0) {
                ItemStack helm = (ItemStack)this.player.field_71071_by.field_70460_b.get(3);
                ItemStack chest = (ItemStack)this.player.field_71071_by.field_70460_b.get(2);
                if (helm.func_77973_b() instanceof AbstractItemDivingGear && chest.func_77973_b() instanceof AbstractItemDivingGear) {
                    ICapabilityOxygen ioxygen = (ICapabilityOxygen)chest.getCapability(CapabilityOxygenProvider.OXYGEN, null);
                    amountReceived += ioxygen.receiveOxygen(amountToReceive);
                }
            }
            return amountReceived;
        }
        return 0;
    }

    @Override
    public int extractOxygen(int amount) {
        amount = MathHelper.func_76125_a((int)amount, (int)0, (int)(this.oxygen + 20));
        this.oxygen -= amount;
        return amount;
    }

    @Override
    public int extractOxygenFromPlayer(int amount) {
        if (amount > 0) {
            int amountToExtract;
            int amountExtracted = 0;
            ItemStack helm = (ItemStack)this.player.field_71071_by.field_70460_b.get(3);
            ItemStack chest = (ItemStack)this.player.field_71071_by.field_70460_b.get(2);
            if (helm.func_77973_b() instanceof AbstractItemDivingGear && chest.func_77973_b() instanceof AbstractItemDivingGear) {
                ICapabilityOxygen ioxygen = (ICapabilityOxygen)chest.getCapability(CapabilityOxygenProvider.OXYGEN, null);
                amountExtracted += ioxygen.extractOxygen(amount);
            }
            if ((amountToExtract = amount - amountExtracted) > 0) {
                amountExtracted += this.extractOxygen(amountToExtract);
            }
            return amountExtracted;
        }
        return 0;
    }

    @Override
    public int getOxygenCapacity() {
        return BetterDivingConfig.getInstance().divingValues.airBase;
    }

    @Override
    public int getOxygenCapacityFromPlayer() {
        int respirationLevel;
        int oxygenCapacity = this.getOxygenCapacity();
        ItemStack helm = (ItemStack)this.player.field_71071_by.field_70460_b.get(3);
        ItemStack chest = (ItemStack)this.player.field_71071_by.field_70460_b.get(2);
        if (helm.func_77973_b() instanceof AbstractItemDivingGear && chest.func_77973_b() instanceof AbstractItemDivingGear) {
            ICapabilityOxygen ioxygen = (ICapabilityOxygen)chest.getCapability(CapabilityOxygenProvider.OXYGEN, null);
            oxygenCapacity += ioxygen.getOxygenCapacity();
        }
        if ((respirationLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185298_f, (ItemStack)helm)) > 0) {
            oxygenCapacity += BetterDivingConfig.getInstance().divingValues.airPerRespirationLevel * respirationLevel;
        }
        return oxygenCapacity;
    }

    @Override
    public double getSwimSpeed() {
        return BetterDivingConfig.getInstance().divingValues.swimSpeed;
    }

    @Override
    public double getSwimSpeedFromPlayer() {
        double hunger;
        if (ItemSeaglide.canUseSeaglide(this.player)) {
            return BetterDivingConfig.getInstance().divingValues.seaglideSpeed;
        }
        double swimSpeedBase = this.getSwimSpeed();
        double swimSpeedBonus = 0.0;
        ItemStack chest = (ItemStack)this.player.field_71071_by.field_70460_b.get(2);
        ItemStack feet = (ItemStack)this.player.field_71071_by.field_70460_b.get(0);
        if (chest.func_77973_b() instanceof AbstractItemDivingGear) {
            swimSpeedBonus += ((AbstractItemDivingGear)chest.func_77973_b()).getSwimSpeed();
        }
        if (feet.func_77973_b() instanceof AbstractItemDivingGear) {
            swimSpeedBonus += ((AbstractItemDivingGear)feet.func_77973_b()).getSwimSpeed();
        }
        if (!this.player.func_184614_ca().func_190926_b()) {
            swimSpeedBonus -= 0.08;
        }
        if (!this.player.func_184592_cb().func_190926_b()) {
            swimSpeedBonus -= 0.08;
        }
        if (!this.player.func_184812_l_() && (hunger = (double)this.player.func_71024_bL().func_75116_a() / 20.0) < 0.2) {
            swimSpeedBonus += 2.5 * hunger - 0.5;
        }
        if (!this.player.func_70055_a(Material.field_151586_h)) {
            swimSpeedBase *= 1.3;
        }
        double min = swimSpeedBase * BetterDivingConfig.getInstance().divingValues.swimSpeedLimitLower;
        double max = swimSpeedBase * BetterDivingConfig.getInstance().divingValues.swimSpeedLimitUpper;
        double speed = MathHelper.func_151237_a((double)(swimSpeedBase * (1.0 + swimSpeedBonus)), (double)min, (double)max);
        int depthStriderLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185300_i, (ItemStack)feet);
        if (depthStriderLevel > 0) {
            speed += swimSpeedBase * BetterDivingConfig.getInstance().divingValues.swimSpeedDepthStrider * (double)depthStriderLevel;
        }
        return speed;
    }

    @Override
    public float getBreakSpeed() {
        return (float)BetterDivingConfig.getInstance().divingValues.breakSpeed;
    }

    @Override
    public float getBreakSpeedFromPlayer() {
        float breakSpeed = this.getBreakSpeed();
        ItemStack helm = (ItemStack)this.player.field_71071_by.field_70460_b.get(3);
        ItemStack legs = (ItemStack)this.player.field_71071_by.field_70460_b.get(1);
        if (legs.func_77973_b() instanceof AbstractItemDivingGear) {
            breakSpeed *= 1.0f + ((AbstractItemDivingGear)legs.func_77973_b()).getBreakSpeed();
        }
        if (this.player.func_70055_a(Material.field_151586_h)) {
            int aquaAffinityLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185299_g, (ItemStack)helm);
            breakSpeed = aquaAffinityLevel > 0 ? (breakSpeed *= 1.0f + (float)BetterDivingConfig.getInstance().divingValues.breakSpeedAquaAffinity * (float)aquaAffinityLevel) : (breakSpeed *= 5.0f);
        }
        if (!this.player.field_70122_E) {
            breakSpeed *= 5.0f;
        }
        return breakSpeed;
    }

    @Override
    public void setIsDiving(boolean isDiving) {
        this.isDiving = isDiving;
    }

    @Override
    public boolean isDiving() {
        return this.isDiving;
    }

    @Override
    public void setPrevIsDiving(boolean prevIsDiving) {
        this.prevIsDiving = prevIsDiving;
    }

    @Override
    public boolean prevIsDiving() {
        return this.prevIsDiving;
    }

    @Override
    public void setDivingTick(float divingTick) {
        this.divingTick = divingTick;
    }

    @Override
    public float getDivingTick() {
        return this.divingTick;
    }

    @Override
    public void setPrevDivingTick(float prevDivingTick) {
        this.prevDivingTick = prevDivingTick;
    }

    @Override
    public float getPrevDivingTick() {
        return this.prevDivingTick;
    }

    @Override
    public void setDivingTickHorizontal(float divingTickHorizontal) {
        this.divingTickHorizontal = divingTickHorizontal;
    }

    @Override
    public float getDivingTickHorizontal() {
        return this.divingTickHorizontal;
    }

    @Override
    public void setPrevDivingTickHorizontal(float prevDivingTickHorizontal) {
        this.prevDivingTickHorizontal = prevDivingTickHorizontal;
    }

    @Override
    public float getPrevDivingTickHorizontal() {
        return this.prevDivingTickHorizontal;
    }

    @Override
    public void setDivingTickVertical(float divingTickVertical) {
        this.divingTickVertical = divingTickVertical;
    }

    @Override
    public float getDivingTickVertical() {
        return this.divingTickVertical;
    }

    @Override
    public void setPrevDivingTickVertical(float prevDivingTickVertical) {
        this.prevDivingTickVertical = prevDivingTickVertical;
    }

    @Override
    public float getPrevDivingTickVertical() {
        return this.prevDivingTickVertical;
    }
}

