/*
 * Decompiled with CFR 0.152.
 */
package meldexun.better_diving.capability.diving.event;

import meldexun.better_diving.BetterDiving;
import meldexun.better_diving.capability.diving.CapabilityDivingAttributesProvider;
import meldexun.better_diving.capability.diving.ICapabilityDivingAttributes;
import meldexun.better_diving.integration.IndustrialCraft;
import meldexun.better_diving.network.packet.SPacketSyncOxygen;
import meldexun.better_diving.util.BetterDivingConfig;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="better_diving")
public class CapabilityDivingAttributesEventHandler {
    private CapabilityDivingAttributesEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        if (BetterDivingConfig.getInstance().modules.blockBreaking && player.func_70090_H() && !IndustrialCraft.isDrilling((EntityLivingBase)player)) {
            ICapabilityDivingAttributes idiving = (ICapabilityDivingAttributes)player.getCapability(CapabilityDivingAttributesProvider.DIVING_ATTRIBUTES, null);
            event.setNewSpeed(event.getNewSpeed() * idiving.getBreakSpeedFromPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayer player = event.player;
            BetterDiving.network.sendTo((IMessage)new SPacketSyncOxygen(player), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayer player = event.player;
            BetterDiving.network.sendTo((IMessage)new SPacketSyncOxygen(player), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayer player = event.player;
            BetterDiving.network.sendTo((IMessage)new SPacketSyncOxygen(player), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        ICapabilityDivingAttributes idiving = (ICapabilityDivingAttributes)event.player.getCapability(CapabilityDivingAttributesProvider.DIVING_ATTRIBUTES, null);
        if (!(event.phase != TickEvent.Phase.END || event.player.field_70170_p.field_72995_K && event.player instanceof EntityOtherPlayerMP)) {
            idiving.tick();
        }
        idiving.updateSize();
    }
}

